/*
 *     .
 *      .
 *
 *    ,      ().
 *     8  ().
 *    1 .
 *    ,    
 *  .
 *
 *         .
 *    ,       ,
 *   ,  1  ( ).
 *          ,
 *         ( ),
 *   ,    .
 *
 *    256  .   
 *   ,    .
 *    0   
 *    .
 *
 *     :
 *
 *    0     1     2     3     4     5     6     7 -  
 * -------------------------------------------------    
 * |  |  | . |  .  |
 * -------------------------------------------------
 *
 *           -  
 *           -  
 * .    -     (8 )
 * ..-  ,   
 *
 * : -     , 
 *    ()  .
 */

/*$Header:$*/

/*$Log:$*/

/*
 * bcinit ()
 *              -  : ,   .
 *
 * bcsetup (subchan, psintr, printr)
 * int subchan;         -  , 1..NBCHAN
 * int (*psintr) ();    -    .
 * int (*printr) ();    -   .
 *
 *              -  .
 *
 * bcsend (subchan, op, info, len, data)
 * int subchan;         -  , 1..NBCHAN
 * int op;              -  .
 * int info;            -  .
 * int len;             -      0.
 * int *data;           -    0.
 *
 *              -      .
 *                 ,  bcstart ().
 *
 * bcrintr ()
 *              -    .
 *               .  ,
 *               .    ,
 *                .  
 *              (*printr) (subchan, op, info, len, data).
 *               .
 *
 * bcsintr ()
 *              -     .
 *                 .  (*psintr) (subchan).
 *               bcstart ().
 *
 * bcstart ()
 *              -   .     
 *               ,  .
 */

#define BCHANNUM        1       /*    */
#define NBCHAN          8       /*  8    */

typedef int (*funcptr) ();

struct chanhead {               /*     */
	unsigned subchan :8;    /*   */
	unsigned op      :8;    /*   */
	unsigned len     :16;   /*   */
	unsigned info    :32;   /*   */
};

struct chanpacket {             /*    */
	struct chanhead header; /*  */
	char data [BSIZE];      /*  */
};

struct subchantab {             /*    */
	int subchan;            /*   */
	int opened;             /*   */
	int active;             /*    */
	funcptr rintr;          /*     */
	funcptr sintr;          /*     */
	struct chanhead ohd;    /*    */
	int olen;               /*     */
	int *odata;             /*     */
	int odataflag;          /*      */
	struct subchantab *next; /*     */
};

struct chantab {                                /*    */
	int chan;                               /*   */
	int opened;                             /*   */
	int active;                             /*    */
	struct subchantab *first;               /*    */
	struct subchantab *last;                /*   */
	struct subchantab subchan [NBCHAN+1];   /*  */
	struct chanpacket rbuf;                 /*     */
	int idataflag;                          /*   .  */
};

struct chantab bchan;           /*   */

bcinit ()
{
	register struct chantab *cp = chantab;

	cp->chan = BCHANNUM;
	cp->first = 0;
	cp->last = 0;
	cp->active = 0;
	cp->idataflag = 0;
	cp->opened = 0;

	/*   */

	rez = dvs_ex4 (0xed1, cp->chan*2, cp->chan*2 + 1, 0, 0);
	if (rez) {
		if (rez == 1)
			printf (" %d-\n", cp->chan);
		else if (rez == 2)
			printf ("%d- \n", cp->chan);
		return;
	}
	rez = dvs_ex4 (0xed1, cp->chan*2 + 1, cp->chan*2 + 2, 0, 0);
	if (rez) {
		if (rez == 1)
			printf (" %d-\n", cp->chan);
		else if (rez == 2)
			printf ("%d- \n", cp->chan);
		dvs_ex1 (0xed2, cp->chan*2);
		return;
	}

	cp->opened = 1;

	/*   . */
	bcrstart (cp);
}

bcsetup (subchan, psintr, printr)
funcptr psintr;
funcptr printr;
{
	register struct chantab *cp = chantab;
	register struct subchantab *scp;

	if (! cp->opened)
		bcinit ();
	if (subchan<1 || subchan>NBCHAN) {
		printf ("  : %d!\n", subchan);
		return;
	}
	scp = cp->subchan [subchan];
	scp->subchan = subchan;
	scp->rintr = printr;
	scp->sintr = psintr;
	scp->active = 0;
	if (psintr)
		scp->opened = 1;        /*   */
	else
		scp->opened = 0;        /*   */
}

bcsend (subchan, op, info, len, data)
int *data;
{
	register struct chantab *cp = chantab;
	register struct subchantab *scp;

	if (subchan<1 || subchan>NBCHAN) {
		printf ("  : %d!\n", subchan);
		return;
	}
	scp = cp->subchan [subchan];
	if (! scp->opened) {
		printf (" %d  \n", subchan);
		return;
	}
	if (scp->active) {
		printf (" %d  !\n", subchan);
		return;
	}

	/*  . */

	scp->ohd.subchan = subchan;
	scp->ohd.op = op;
	scp->ohd.len = len;
	scp->ohd.info = info;

	scp->olen = len;
	scp->odata = data;
	scp->active = 1;
	scp->odataflag = 0;

	/*      . */

	scp->next = 0;
	if (cp->first) {
		cp->last->next = scp;
		cp->last = scp;
	} else {
		cp->first = scp;
		cp->last = scp;
	}

	/*    ,  bcstart (). */

	if (! cp->active)
		bcstart (cp);
}

bcrintr (chan)
{
	register struct chantab *cp = chantab;
	register struct subchantab *scp;
	register struct chanhead *h;
	int subchan;
	int plen, rez;

	/*    . */
	if (chan != cp->chan)
		return;

	/*    */
	rez = get_reg (BC_DEM, cp->chan*2 + 1) & 0x7f;
	if (rez) {
		printf (" %d-: 0x%x\n", cp->chan, rez);
		goto out;
	}

	h = &cp->rbuf.header;
	subchan = h->subchan;
	if (subchan<1 || subchan>NBCHAN) {
		printf ("     : %d\n",
			subchan);
		goto out;
	}
	scp = &cp->subchan [subchan];
	if (! scp->opened) {
		printf (" %d    \n", subchan);
		goto out;
	}

	/*      , >0 */
	plen = get_reg (BC_DEM, cp->chan*2 + 1) >> 24 & 0xffff;
	plen = (plen + 7) / 8;

	if (cp->idataflag) {
		/*     . */
		/*    . */
		plen += 1;
		cp->idataflag = 0;
	}
	if (plen == 1) {
		/*  . */
		if (h->len) {
			/*    . */
			cp->idataflag = 1;
			goto out;
		}
		(*scp->rintr) (subchan, h->op, h->info, 0, 0);
	} else {
		/*    . */
		if (h->len != plen-1)
			printf ("   (%d)   (%d)\n",
				h->len, plen);
		(*scp->rintr) (subchan, h->op, h->info,
			(plen - 1) * 8, h->data);
	}
out:
	/*  . */
	bcrstart (cp);
}

bcsintr (chan)
{
	register struct chantab *cp = chantab;
	register struct subchantab *scp = cp->first;

	/*     . */
	if (chan != cp->chan)
		return;

	/*    */
	rez = get_reg (BC_DEM, cp->chan*2) & 0xff;
	if (rez) {
		printf (" %d- (0x%x), \n",
			cp->chan, rez);
		bcstart (cp);
		return;
	}

	if (! scp)
		return;
	cp->active = 0;

	if (scp->odataflag || ! scp->olen) {
		/*  .    . */

		cp->first = scp->next;
		scp->active = 0;
		if (scp->sintr)
			(*scp->sintr) (scp->subchan);
		bcstart (cp);
	} else {
		/*   .   . */

		cp->active = 1;
		scp->odataflag = 1;
		while (dvs_ex4 (0xad9, cp->chan * 2, 0, olen, scp->odata)
			printf ("     %d\n",
				cp->chan);
	}
}

bcstart (cp)
register struct chantab *cp;
{
	register struct subchantab *scp;

	/*        */
	scp = cp->first;
	while (scp && ! scp->active) {
		printf ("   \n");
		cp->first = scp->next;
		scp = cp->first;
	}
	if (! scp)
		return;
	cp->active = 1;

	/*
	 *  .   ,
	 *   bsintr,   ,   .
	 */

	while (dvs_ex4 (0xad9, cp->chan * 2, 0, 8, &cp->ohd)
		printf ("     %d\n", cp->chan);
}

bcrstart (cp)
register struct chantab *cp;
{
	if (cp->idataflag)
		/*     */
		dvs_ex4 (0xad9, cp->chan * 2 + 1, 0,
			sizeof (cp->rbuf.data), &cp->rbuf.data);
	else
		/*   */
		dvs_ex4 (0xad9, cp->chan * 2 + 1, 0,
			sizeof (cp->rbuf), &cp->rbuf);
}
