# include "svsb.h"
# include "bcio.h"

/* # define DEBUG */

# define in             _in_
# define out            _out_

# define DELAY(n)       { int i=n; while (--i>=0); }

int bcrdflags;
int bcwrflags;

/*
 *    
 *    
 *        
 */

int bcrd (chan, addr, size)
int chan;               /*  , 3  */
char *addr;             /*    , 23  */
int size;               /*    , 19  */
{
	struct bccmd ccw;
	int csw, waitmask;      /*      */

	ccw.addr = (int) addr;
	ccw.count = size >> 3;
	ccw.bcount = size & 7;
	ccw.flg = bcrdflags;

	waitmask = BCC_IN (chan);       /*       */

# ifdef DEBUG
	printf ("scrd: %w", ccw);
# endif
	_flush_ ();                             /*   */
	out (BC_ICW (chan) | BCA_START, ccw);   /*   */

	while (! (in (BC_CTL) & waitmask))      /*    */
		idle (1);
	csw = in (BC_ISW (chan) | BCA_NOHALT | BCA_RESET);      /*    */
# ifdef DEBUG
	printf (" -> %w\n", csw);
# endif
	return (csw);
}

/*
 *    
 *    
 *        
 */

int bcwr (chan, addr, size)
int chan;               /*  , 3  */
char *addr;             /*    , 23  */
int size;               /*    , 19  */
{
	struct bccmd ccw;
	int csw, waitmask;      /*      */

	ccw.addr = (int) addr;
	ccw.count = size >> 3;
	ccw.bcount = size & 7;
	ccw.flg = bcwrflags;

	waitmask = BCC_OUT (chan);      /*       */

# ifdef DEBUG
	printf ("scwr: %w", ccw);
# endif
	_flush_ ();                             /*   */
	out (BC_OCW (chan) | BCA_START, ccw);   /*   */

	while (! (in (BC_CTL) & waitmask))      /*    */
		idle (1);
	csw = in (BC_OSW (chan) | BCA_NOHALT | BCA_RESET);      /*    */
# ifdef DEBUG
	printf (" -> %w\n", csw);
# endif
	return (csw);
}

/*
 * -   
 *    
 *        
 */

int bcrdwr (chan, raddr, waddr, size)
int chan;               /*  , 3  */
char *raddr, *waddr;    /*    , 23  */
int size;               /*    , 19  */
{
	struct bccmd ccwr, ccww;
	int cswr, csww;
	int rwaitmask, wwaitmask;       /*      */

	ccwr.addr = (int) raddr;
	ccwr.count = size >> 3;
	ccwr.bcount = size & 7;
	ccwr.flg = bcrdflags;
	ccww.addr = (int) waddr;
	ccww.count = size >> 3;
	ccww.bcount = size & 7;
	ccww.flg = bcwrflags;

	rwaitmask = BCC_IN (chan);       /*       */
	wwaitmask = BCC_OUT (chan);      /*       */

# ifdef DEBUG
	printf ("scrd=%w  scwr=%w", ccwr, ccww);
# endif
	_flush_ ();                             /*   */
	out (BC_ICW (chan) | BCA_START, ccwr);  /*   */
	out (BC_OCW (chan) | BCA_START, ccww);  /*   */

	while (! (in (BC_CTL) & rwaitmask))      /*    */
		idle (1);
	while (! (in (BC_CTL) & wwaitmask))      /*    */
		idle (1);
	cswr = in (BC_ISW (chan) | BCA_NOHALT | BCA_RESET);     /*    */
	csww = in (BC_OSW (chan) | BCA_NOHALT | BCA_RESET);     /*    */
# ifdef DEBUG
	printf (" -> %w  %w\n", cswr, scww);
# endif
	return ((cswr & 0xff) << 8 | (csww & 0xff));
}

/*
 *   
 */

bcreset (chan)
int chan;               /*  , 3  */
{
	register i, a;

	in (BC_OSW (chan) | BCA_NOHALT | BCA_RESET);
	in (BC_ISW (chan) | BCA_NOHALT | BCA_RESET);
	a = BC_LMEM (chan);                     /*   */
	for (i=0; i<4; ++i)
		out (a + i, 0);                 /*    */
	out (BC_CTL, 0);                        /*    */
}

/*
 *   
 */

bcinit ()
{
	int chan;

	for (chan=0; chan<8; ++chan)
		bcreset (chan);
}
