/*
 *     DOS.
 * ------------------------------
 *
 *       22h -   .
 *       23h - .
 *
 *     PC.
 *
 *      1)    22h, 
 *        .
 *
 *      2)  .
 *
 *      3)     23h.
 *
 *      4)     22h.
 *
 *     -.
 *
 *      1)     22h.
 *
 *      2)  0   22h.
 *
 *      3)     23h.
 *
 *  .
 *
 * -------------------------------------------------
 * |                 |      |   |   |
 * -------------------------------------------------
 *  64                  33 32       17 16   9 8   1
 *
 *  .
 *
 * -------------------------------------------------
 * |            |   |   |   |
 * -------------------------------------------------
 *  64                  33 32       17 16   9 8   1
 *
 *  .
 *
 *      1)  
 *
 *              char    op;             DOPEN
 *              char    mode;           r=0, w=1, r/w=2
 *              short   length;          
 *              long    addr;            
 *
 *         :
 *
 *              char    err;            1    
 *              char    fd;             
 *
 *      2) /
 *
 *              char    op;             DREAD/DWRITE
 *              char    fd;              
 *              short   length;           
 *              long    addr;            
 *
 *         :
 *
 *              char    err;            1   
 *              short   length;          
 *
 *      3)  
 *
 *              char    op;             DCLOSE
 *              char    fd;              
 *
 *         :
 *
 *              char    err;            1    
 *
 *      4)  (lseek)
 *
 *              char    op;             DSEEK
 *              char    fd;              
 *              short   pos;            0=beg, 1=end, 2=place
 *              long    offset;
 *
 *         :
 *
 *              char    err;            1  
 *
 *      5)  
 *
 *              char    op;             DOPENDIR
 *              short   length;          
 *              long    addr;            
 *
 *         :
 *
 *              char    err;            1    
 *              char    fd;              
 *
 *      6)  
 *
 *              char    op;             DREADDIR
 *              char    fd;              
 *              long    addr;           4   
 *
 *         :
 *
 *              char    err;            1   
 *              char    neof;           0   
 *
 *      7)    
 *
 *              char    op;             DSTAT
 *              char    fd;              
 *              short   length;          
 *              long    addr;            
 *
 *         :
 *
 *              char    err;            1  
 *              char    type;            0-, 1-, >1-.
 *              long    length;          
 */

# include "dosio.h"
# include "svsb.h"

/* # define DEBUG */

dosopen (name, mode)
char *name;
{
	struct dosio io;
	struct dosreply reply;
	char nambuf [80];

	strcpy (nambuf, name);
	io.op = DOPEN;
	io.fd = mode==2 ? 2 : mode==1 ? 1 : 0;
	io.length = strlen (nambuf);
	io.addr = (int) nambuf;
# ifdef DEBUG
	printf ("***** dosopen '%s' mode 0x%x\n", nambuf, mode);
# endif /* DEBUG */
	doswait (&io, &reply);
	return (reply.err ? -1 : reply.type);
}

dosclose (fd)
{
	struct dosio io;
	struct dosreply reply;

	io.op = DCLOSE;
	io.fd = fd;
	io.length = 0;
	io.addr = 0;
	doswait (&io, &reply);
	return (reply.err ? -1 : 0);
}

dosread (fd, buf, len)
char *buf;
{
	struct dosio io;
	struct dosreply reply;

	io.op = DREAD;
	io.fd = fd;
	io.length = len;
	io.addr = (int) buf;
	doswait (&io, &reply);
	return (reply.err ? -1 : reply.length);
}

doswrite (fd, buf, len)
char *buf;
{
	struct dosio io;
	struct dosreply reply;

	io.op = DWRITE;
	io.fd = fd;
	io.length = len;
	io.addr = (int) buf;
	doswait (&io, &reply);
	return (reply.err ? -1 : reply.length);
}

doslseek (fd, offset, pos)
{
	struct dosio io;
	struct dosreply reply;

	io.op = DSEEK;
	io.fd = fd;
	io.length = pos;
	io.addr = offset;
	doswait (&io, &reply);
	return (reply.err ? -1 : 0);
}

dosopendir (name)
char *name;
{
	struct dosio io;
	struct dosreply reply;
	char nambuf [80];

	strcpy (nambuf, name);
	io.op = DOPENDIR;
	io.fd = 0;
	io.length = strlen (nambuf);
	io.addr = (int) nambuf;
	doswait (&io, &reply);
	return (reply.err ? -1 : reply.type);
}

dosreaddir (fd, buf)
char *buf;
{
	struct dosio io;
	struct dosreply reply;

	io.op = DREADDIR;
	io.fd = fd;
	io.length = 32;
	io.addr = (int) buf;
	doswait (&io, &reply);
	return (reply.err ? -1 : reply.type);
}

dosstat (fd, name, ptype, plen)
char *name;
int *ptype, *plen;
{
	struct dosio io;
	struct dosreply reply;

	io.op = DSTAT;
	io.fd = fd;
	io.length = strlen (name);
	io.addr = (int) name;
	doswait (&io, &reply);
	*ptype = reply.type;
	*plen = reply.addr;
	return (reply.err ? -1 : 0);
}

static doswait (o, r)
register struct dosio *o;
register struct dosreply *r;
{
	int u;

	u = o->op & 0xff | (o->fd & 0xff) << 8 |
		(o->length & 0xffff) << 16 | o->addr << 32;

# ifdef DEBUG
	printf ("***** dosio %w\n", u);
# endif /* DEBUG */

	_dosout = u;
	_flush_ ();                     /*   */
	while (_dosout)
		idle (1);
# ifdef DEBUG
	printf ("***** reply %w\n", _dosin);
# endif /* DEBUG */

	r->err = _dosin & 0xff;
	r->type = _dosin >> 8 & 0xff;
	r->length = _dosin >> 16 & 0xffff;
	r->addr = _dosin >> 32 & 0x7fffffff;
}
