/*
 *  -  -
 * ==============================
 *
 *    -
 * -------------------------------------------
 *
 * (1)  .  - 
 *   
 *
 *              YY 07 64 0000 AAAAAA
 *
 *      YY -  
 *
 *              .       YY+
 *                        
 *           ------------------------------
 *              0               38
 *              1               d8
 *              2               58
 *              3               80
 *
 *      AAAAAA - .  
 *
 *              0000 0 00 XXXX
 *
 *       -  , 0-814
 *       -  , 0-18
 *
 * (2)   
 *
 *              YY 31 54 0000 AAAAAA
 *
 *      AAAAAA -  , , 
 *
 *              0 00 00 0000
 *
 *       -  , 0-814
 *       -  , 0-18
 *       -   (), 1-10
 *
 * (3)    
 *
 *              YY 08 0c 0000 AAAAAA
 *
 *      AAAAAA -   
 *
 * (4)  
 *
 *              YY ZZ 84 0083 AAAAAA
 *
 *      ZZ - : =06, =05
 *      AAAAAA -   , 131 
 *
 *  (1)-(4)      .
 *     ,  (1)   
 *
 *    43  =0.
 */

# include "param.h"
# include "inode.h"
# include "fs.h"

# include "saio.h"
# include "scio.h"
# include "svsb.h"

# define DEBUG

# define HPC            19              /* heads per cylinder */
# define BPT            10              /* blocks per track */
# define NCYL           808             /* number of cylinders in use */

# define BPC            (HPC*BPT)       /* blocks per cylinder */
# define NBLOCKS        (NCYL*HPC*BPT)

# define MAXRETRY       5               /* max number of retry */

# define MAXCPSZ        16              /* .    */

struct sccmd hdsense = {
/*    addr    count   flg     cmd     unit    */
/* &hdsbuf */           0,      3,      0,      4,      0,
};

int hdsbuf [3];

# ifdef CORR
struct sccmd hdcorr [3] = {
/*   . . addr    count   flg     cmd     unit    */
/* &hdsbuf[1] */        0,      0,      0x54,   0x31,   0,
/* .-1 */               0,      0,      0x04,   0x08,   0,
/*  */               0,      0,      0,      0x08,   0,
};
# endif

struct sccmd hdsample [4] = {
/*           addr    count   flg     cmd     unit    */
/* &hdcyl */            0,      0,      0x64,   0x07,   0,
/* &hdblock */          0,      0,      0x54,   0x31,   0,
/* .-1 */               0,      0,      0x0c,   0x08,   0,
/* &hdbuf */            0,      131,    0x84,   0x06,   0,
};

struct sccmd hdprog [4*MAXCPSZ];
int nprog;                      /*      */

int hdchan = 0;                 /*    */

int hdcyl [MAXCPSZ];            /* 0000 0ccc 00hh xxxx */
int hdblock [MAXCPSZ];          /* 0ccc 00hh bb00 0000 */
int hdbuf [MAXCPSZ] [131];      /* io buffer */

int hdcsw;                      /* channel status word */
int hdunit;                     /* unit address for channel program */

extern chantab [];

hdopen (io)
register struct iob *io;
{
	static firsttime = 1;

	io->i_unit &= 7;
	screset (hdchan);

	if (io->i_partname [0]) {
		printf (MSG ("hd: cannot handle partitions yet\n",
			"hd:    \n"));
		io->i_boff = 0;
		io->i_dsz = NBLOCKS;
	} else if (! io->i_dsz)
		io->i_dsz = NBLOCKS;
	if (! firsttime)
		return;

	hdsense.addr = (int) hdsbuf;
	firsttime = 0;
}

hdstrategy (io, func)
register struct iob *io;
{
	/* io->i_ma -    */
	/* io->i_cc -     */
	/* io->i_bn -   */
	int n, i;

	if (io->i_bn < 0 || io->i_bn >= io->i_boff+io->i_dsz)
		return (0);
	n = io->i_cc / DEV_BSIZE;
	if (io->i_cc != n*DEV_BSIZE) {
		printf (MSG ("hd: bad block length %d\n",
			"hd:    %d\n"), io->i_cc);
		return (-1);
	}
	if (io->i_bn+n > io->i_boff+io->i_dsz)
		n = io->i_dsz - io->i_bn;
	if (func == WRITE) {
		for (i=0; i<n; ++i) {
			bcopy (io->i_ma+i*DEV_BSIZE, hdbuf [i], DEV_BSIZE);
			hdbuf [i] [128] = crc (hdbuf [i]);
			hdbuf [i] [129] = hdbuf [i] [130] = 0;
			clrtg (hdbuf [i]);
		}
	}
	if (hdrw (hdchan, io->i_unit, func==WRITE ? 0 : 1, io->i_bn, n) < 0)
		return (-1);
	if (func == READ) {
		for (i=0; i<n; ++i) {
			if (hdbuf [i] [128] != crc (hdbuf [i])) {
				printf (MSG ("hd: bad checksum, block %d\n",
					"hd:  ,  %d\n"), io->i_bn+i);
				return (-1);
			}
			bcopy (hdbuf [i], io->i_ma+i*DEV_BSIZE, DEV_BSIZE);
		}
	}
	return (n * DEV_BSIZE);
}

/* ARGSUSED */
hdioctl (io, cmd, arg)
struct iob *io;
int cmd;
caddr_t arg;
{
	return (ECMD);
}

int hdrw (chan, unit, rd, nblock, sz)
{
	if (nblock<0 || nblock+sz>NBLOCKS) {
		printf (MSG ("hd: bad block number %d:%d\n",
			"hd:    %d:%d\n"), nblock, sz);
		return (-1);
	}
	hdsetup (chan, unit, rd, nblock, sz);
	if (hdio (chan, hdprog) < 0)
		return (-1);
	return (0);
}

hdsetup (chan, unit, rd, nblock, sz)
{
	int c, h, b, i;

	/*    */
	nprog = 0;
	for (i=0; i<sz; ++i, ++nblock) {
		c = nblock / BPC;       /*   */
		b = nblock - c * BPC;
		h = b / BPT;            /*   */
		b = b - h * BPT + 1;    /*   */

		hdcyl [i] = c<<32 | h<<16 | b<<8;
		hdblock [i] = hdcyl [i] << 16;

		if (! i || (hdcyl[i] ^ hdcyl[i-1]) >> 16) {
			/*     */
			hdprog[nprog] = hdsample[0];
			hdprog[nprog++].addr = (int) &hdcyl[i];
		}
		hdprog[nprog] = hdsample[1];
		hdprog[nprog++].addr = (int) &hdblock[i];
		hdprog[nprog] = hdsample[2];
		hdprog[nprog].addr = (int) &hdprog[nprog-1];
		hdprog[++nprog] = hdsample[3];
		hdprog[nprog].addr = (int) hdbuf[i];
		hdprog[nprog++].cmd = rd ? 6 : 5;
	}

	/*    */
	hdunit = chantab [chan & 3] + unit;
	hdsense.unit = hdunit;
	for (i=0; i<nprog; ++i)
		hdprog[i].unit = hdunit;

	/*    */
	hdprog[nprog-1].flg &= ~4;
}

int hdio (chan, prog)
struct sccmd *prog;
{
	int retry, csb;
	int caw, ccw;

	retry = 0;
repeat:
	hdcsw = scwait (chan, prog);
swtch:
	switch (hdcsw>>1 & 7) {
	case 2:         /*   */
		printf (MSG ("hd: unit not ready\n", "hd:   \n"));
		break;
	case 3:         /* .   */
		printf (MSG ("hd: bad unit address\n", "hd: .  \n"));
		return (-1);
	case 4:         /*    */
		printf (MSG ("hd: unit not found\n", "hd:   \n"));
		return (-1);
	case 6:         /* .   */
		printf (MSG ("hd: RAM error\n", "hd:  \n"));
		return (-1);
	case 7:         /*    */
		printf (MSG ("hd: bad transfer\n", "hd:  \n"));
		return (-1);
	case 0:
		if ((hdcsw >> 32 & 0xff) != hdunit) {
badunit:                printf (MSG ("hd: bad unit in csw\n",
				"hd:      \n"));
			break;
		}
		if (hdcsw & 0x1f80) {
badram:                 printf (MSG ("hd: RAM error\n",
				"hd:  \n"));
			break;
		}
		csb = hdcsw >> 16 & 0xffff;
		if (csb == 0x0804) {
done:                   /*   */
			_in_ (SC_CSW (chan) | SCA_RESET | SCA_NOHALT);
			return (0);
		}
		if (csb == 0x4a04) {
unitbusy:               /*   */
			_in_ (SC_CCW (chan) | SCA_RESET|SCA_NOHALT|SCA_SBLOCK);
			goto repeat;
		}
		break;
	case 1:
		if ((hdcsw >> 24 & 0xff) != hdunit)
			goto badunit;
		if (hdcsw & 0x1f80)
			goto badram;
		csb = hdcsw >> 16 & 0xff;
		if (csb == 0x0c || csb == 0x08)
			goto done;
		if (csb == 0x4e)
			goto unitbusy;
		break;
	}
	ccw = _in_ (SC_CCW (hdchan) | SCA_NOHALT);              /*  */
	caw = _in_ (SC_CAW (hdchan) | SCA_NOHALT) & 0x7fffff;   /*  */
	_in_ (SC_CCW (chan) | SCA_RESET | SCA_NOHALT);          /*  */

	/*   */
	scwait (chan, &hdsense);

	/*   */
	_in_ (SC_CSW (chan) | SCA_RESET | SCA_NOHALT);

# ifdef DEBUG
	printf ("\n=%w  =%w  =%w\n", ccw, hdcsw, caw);
	printf ("0=%w  1=%w  2=%w\n", hdsbuf[0], hdsbuf[1], hdsbuf[2]);
# endif
	if (retry > MAXRETRY) {
		printf (MSG ("hd: cannot recover by retry\n",
			"hd:   \n"));
		return (-1);
	}
	if ((hdsbuf [0] & 0xff) == 0x53) {
		printf (MSG ("hd: adjustable io error",
			"hd:  "));
# ifdef CORR
		/*  */
		if (hdcsw = hdcorr (ccw, caw))
			goto swtch;
		goto done;
# endif
	} else
		printf (MSG ("hd: io error", "hd:  "));
	printf (MSG (", csw=%w, retrying\n", ", =%w, \n"), hdcsw);
	++retry;
	goto repeat;
}

# ifdef CORR
hdcorr (ccw, caw)
{
	/*  */
	/*    0 */
	char *nb;
	register *p;
	int i;

	if (ccw >> 47 & 1) {
		/*     */
		???
	}
	nb = (ccw & 0x7fffff) << 3 + (hdsbuf[2]>>48 & 0xffff) -
		(hdsbuf[2]>>32 & 0xffff);
	p = (int *) (nb >> 3);
	nb &= 7;
	for (i=0; i<3; ++i)
		*p ^= (hdsbuf[2] >> (24-i*8) & 0xff) << (56-nb*8);
	if (! (ccw >> 42 & 1))          /*     */
		return (0);
	/*      */
	hdcorr[0].unit = hdunit;
	hdcorr[1].unit = hdunit;
	hdcorr[2].unit = hdunit;
	hdcorr[2].addr = caw;
	return (scwait (hdchan, hdcorr));
}
# endif
