/*
 *  -  -
 * ===============================
 *   808 x 19 x 10 x 1k  
 *
 *    815   19 .
 *   - 13440 .
 *    - 208,118,400  (198 Mb).
 *      
 *  92+13+7+49+11+7 = 179 .
 *   N    L .
 *     
 * 59+11+7+49+7 = 133 .
 *
 *    N=10, L=131*9=1179 ,
 *   808*19*10k = 153,520k (149 Mb).
 *
 * (L + 133) * N + 179 = 13299 < 13440
 *
 *      -
 * 1)   
 * 2)   6   2k  3   4k.
 *  808*19*12k = 184,224k (179 Mb),  30 Mb.
 *
 *     
 * ----------------------------------------------
 *
 * (1)  
 *
 *              YY 1f 14 0000 AAAAAA
 *
 *      AAAAAA -  
 *
 *              c000 0000 0000 0000
 *
 * (2)  
 *
 *              YY 07 64 0000 AAAAAA
 *
 *      AAAAAA -  
 *
 *              0000 0 00 XXXX
 *
 *       -  , 0-813
 *       -  , 0-18
 *
 * (3)  . 
 *
 *              YY 39 44 0000 AAAAAA
 *
 *      AAAAAA -  
 *
 *              0 00 0000 0000
 *
 * (4)    
 *
 *              YY 08 04 0000 AAAAAA
 *
 *      AAAAAA -   
 *
 * (5)  . 
 *
 *              YY 19 34 0001 AAAAAA
 *
 *      AAAAAA -  
 *
 *              000 00 80 0080
 *              0080 0000 0000 0000
 *
 * (6)  
 *
 *              YY 15 04 0001 AAAAAA
 *
 *      AAAAAA -  ,    (3)
 *
 * (7) - (16) 10       
 *
 *              YY 1d 34 0094 AAAAAA
 *
 *      AAAAAA -    149 .
 *       1187  ( .  - 3 ).
 *        10-    .
 *
 * (17)  . 
 *
 *              YY 1a 54 0000 AAAAAA
 *
 *      AAAAAA -    1 
 *
 * (18) - (27) 10       
 *
 *              YY 1e 34 0094 AAAAAA
 *
 *      AAAAAA -    149  (1187 ).
 *        10-    .
 *
 *
 *   
 * --------------------------
 *
 * (1) 8  -                            0
 *
 *              0 00 000 049b
 *                              ||
 *                             131*9
 *
 * (2)  128*9/8 == 144          1-144
 *
 *              5555 5555 5555 5555
 *              d8aa aaaa aaaa aaaa
 *              aad8 5555 5555 5555
 *              5555 d8aa aaaa aaaa
 *              aaaa aad8 5555 5555
 *              5555 5555 d8aa aaaa
 *              aaaa aaaa aad8 5555
 *              5555 5555 5555 d8aa
 *              aaaa aaaa aaaa aad8
 *
 * (3) 8  - .                             145
 *
 *              ffff ffff ffff ffff
 *
 * (4) 8x3                                          146-148
 *
 *              d8TT TTNN NNNN BBBB
 *              BBXX 0000 0000 0000
 *              0000 d800 0000 0000
 *
 *      TTTT    -      0303 0303 0303 0303
 *      NNNNNN  -   0..808*19*10-1
 *      BBBBBB  -  44-21 
 *      XX      - 0xd8 ^    
 *
 *
 *    
 * -----------------------------
 *
 *      0 00 0 00
 *          |         |
 *          
 *           
 *
 *
 *  
 * ------------------
 *
 * 1)    (3)  (6) (addr)    
 *
 * 2)    (5) (waddr)  
 *
 *      020 00 ...
 *      ~~
 * 3)   (7) - (27)
 *
 *
 *   
 * -------------------------
 *
 * 1)   (5):
 *
 *      0100 0000 0000 0000
 *      ...
 *
 * 2)   (2) -   
 *
 * 3)   (3)  (6) -   
 */

# include "vollab.h"
# include "svsb.h"
# include "scio.h"

# define K 1024
# define W ((int) sizeof (int))

# define HPC            19              /*    */
# define BPT            10              /*    */
# define NCYL           808             /*   */
# define NPHYSCYL       814             /*  ,  815 */

# define BPC            (HPC*BPT)       /*     */
# define NBLOCKS        (NCYL*HPC*BPT)  /*   */
# define NTRACKS        (NCYL*HPC)      /*   */
# define NPHYSTRACKS    (NPHYSCYL*HPC)  /*   */
# define NREPTRACKS     ((NPHYSCYL-NCYL)*HPC)   /*   */

# define VLABELSZ       9               /*      */

# define DFLTVOLNAME    "unknown"       /*     */
# define EXTVOL         ".vol"          /*  - */
# define EXTLBL         ".lbl"          /*  - */

# define MAXRETRY       10              /* max number of retry */

# define DEBUG

/*    */

# define TFREE  0                       /*  */
# define TUSED  1                       /*  */
# define TBAD   -1                      /*   */

struct word {
	int right:32;
	int left:32;
};

struct fmtcode {
	struct word word [9];
};

struct fmtblock {
	int marker;
	struct fmtcode code [16];
	unsigned checksum;
	int nblock;
	int time;
	int reserved;
};

struct fmtcode fmtcode = {
	{ 0x55555555, 0x55555555, },
	{ 0xaaaaaaaa, 0xd8aaaaaa, },
	{ 0x55555555, 0xaad85555, },
	{ 0xaaaaaaaa, 0x5555d8aa, },
	{ 0x55555555, 0xaaaaaad8, },
	{ 0xd8aaaaaa, 0x55555555, },
	{ 0xaad85555, 0xaaaaaaaa, },
	{ 0x5555d8aa, 0x55555555, },
	{ 0xaaaaaad8, 0xaaaaaaaa, },
};

static struct sccmd fmtbadtrack [] = {
/*     addr    count   flg     cmd     unit    */
/* &fmtmask */          0,      0,      0x14,   0x1f,   0,
/* &fmtcyl */           0,      0,      0x64,   0x07,   0,
/* &fmtaddr */          0,      0,      0x44,   0x39,   0,
/* &fmtbadtrack[2] */   0,      0,      0x04,   0x08,   0,
/* &fmtwaddr */         0,      1,      0x34,   0x19,   0,
/* &fmtaddr */          0,      1,      0,      0x15,   0,
			0,      0,      0,      0,      0,
};

static struct sccmd fmttrack [] = {
/*       addr    count   flg     cmd     unit    */
/* &fmtmask */          0,      0,      0x14,   0x1f,   0,
/* &fmtcyl */           0,      0,      0x64,   0x07,   0,
/* &fmtaddr */          0,      0,      0x44,   0x39,   0,
/* &fmttrack[2] */      0,      0,      0x04,   0x08,   0,
/* &fmtwaddr */         0,      1,      0x34,   0x19,   0,
/* &fmtaddr */          0,      1,      0x04,   0x15,   0,
/* &fmtwr[0] */         0,      0x94,   0x34,   0x1d,   0,
/* &fmtwr[1] */         0,      0x94,   0x34,   0x1d,   0,
/* &fmtwr[2] */         0,      0x94,   0x34,   0x1d,   0,
/* &fmtwr[3] */         0,      0x94,   0x34,   0x1d,   0,
/* &fmtwr[4] */         0,      0x94,   0x34,   0x1d,   0,
/* &fmtwr[5] */         0,      0x94,   0x34,   0x1d,   0,
/* &fmtwr[6] */         0,      0x94,   0x34,   0x1d,   0,
/* &fmtwr[7] */         0,      0x94,   0x34,   0x1d,   0,
/* &fmtwr[8] */         0,      0x94,   0x34,   0x1d,   0,
/* &fmtwr[9] */         0,      0x94,   0x34,   0x1d,   0,
/* &fmtbuf */           0,      0,      0x54,   0x1a,   0,
/* &fmtrd[0] */         0,      0x94,   0x34,   0x1e,   0,
/* &fmtrd[1] */         0,      0x94,   0x34,   0x1e,   0,
/* &fmtrd[2] */         0,      0x94,   0x34,   0x1e,   0,
/* &fmtrd[3] */         0,      0x94,   0x34,   0x1e,   0,
/* &fmtrd[4] */         0,      0x94,   0x34,   0x1e,   0,
/* &fmtrd[5] */         0,      0x94,   0x34,   0x1e,   0,
/* &fmtrd[6] */         0,      0x94,   0x34,   0x1e,   0,
/* &fmtrd[7] */         0,      0x94,   0x34,   0x1e,   0,
/* &fmtrd[8] */         0,      0x94,   0x34,   0x1e,   0,
/* &fmtrd[9] */         0,      0x94,   0x30,   0x1e,   0,
			0,      0,      0,      0,      0,
};

int fmtmask;            /* c000 0000 0000 0000 */
int fmtcyl;             /* 0000 0 00 XXXX */
int fmtaddr;            /* 0 00 0000 0000 */
int fmtwaddr [2];       /* 000 00 80 0080  0080 0000 0000 0000 */

struct fmtblock fmtwr [BPT];
struct fmtblock fmtrd [BPT];

int fmtbuf;

int badtrack [NREPTRACKS];      /*      */
int nbad;                       /*    */

int reptrack [NREPTRACKS];      /*    */
struct btt_entry reptab [NREPTRACKS];   /*   */

int buf [VLABELSZ*K/W];
int unit;                       /*    */
int devunit;                    /*    */

extern hdchan;                  /*    */
extern hdsbuf [];
extern chantab [];
extern struct sccmd hdsense;

yes ()
{
	char rep [80];
	int r;

	printf ("? (y, n, , ) [] ");
	gets (rep);
	r = rep [0];
	if (r=='y' || r=='Y' || r=='' || r=='')
		return (1);
	if (r=='n' || r=='N' || r=='' || r=='')
		return (-1);
	return (0);
}

main ()
{
	char volname [80];

	printf (MSG ("\nFORMAT %s    %s\n", "\n %s    %s\n"),
		BOOTVERSION, MSG (LCOPYRIGHT, RCOPYRIGHT));
	printf (MSG ("\nUsing this program you may OVERWRITE information on your hard disks.\n",
		"\n          .\n"));
	printf (MSG ("\nIt is strongly recommended to TURN unnecessary disks 'READ-ONLY'.\n",
		"\n      .\n"));
	printf (MSG ("Do you want to continue",
		""));
	if (yes () != 1)
		return;
	unit = getunit ();
	nbad = 0;
	getname (volname);
	printf (MSG ("\nFormat unit %d, volume name '%s'",
		"\n  %d,  '%s'"),
		unit, volname);
	switch (yes ()) {
	default:
		return;
	case 0:
		printf (MSG ("\nMake volume label on unit %d, volume name '%s'",
			"\n     %d,  '%s'"),
			unit, volname);
		if (yes () != 1)
			return;
		goto labelonly;
	case 1:
		break;
	}
	/*      */
	init (unit);

	printf (MSG ("\nINITIAL FORMATTING\n", "\n \n"));
	if (! format1 ())
		return;

	if (nbad) {
		printf (MSG ("\nBAD TRACKS REMAPPING\n", "\n\n"));
		if (! format2 ())
			return;
	}
labelonly:
	printf (MSG ("\nWRITING VOLUME LABEL\n", "\n  \n"));
	wrlabel (volname, unit);
	printf (MSG ("\nFormat completed.\n", "\n .\n"));
}

format1 ()
{
	int track;

	/*        */
	for (track=0; track<NPHYSTRACKS; ++track) {
		idle (1);
		if (! (track % HPC))
			printf ("\r%d", track/HPC);
		if (! formattrack (track, 0)) {
			printf ("\r%d.%d\t", track/HPC, track%HPC);
			printf (MSG ("\t***** Bad track\n",
				"\t*****  \n"));
			if (track >= NTRACKS)
				/*    */
				reptrack [track-NTRACKS] = TBAD;
			else {
				if (nbad >= NREPTRACKS) {
					printf (MSG ("\nTOO MANY BAD TRACKS -- FORMAT ABORTED\n",
						"\n    --  \n"));
					return (0);
				}
				badtrack [nbad++] = track;
			}
			printf ("%d", track/HPC);
		}
	}
	return (1);
}

format2 ()
{
	int track, rep, i;

	/*    */
	for (i=0; i<nbad; ++i) {
		track = badtrack [i];
		do
			if (! (rep = findrep ())) {
				printf (MSG ("\nBAD TRACK TABLE OVERFLOW -- FORMAT ABORTED\n",
					"\n     --  \n"));
				return (0);
			}
		while (! formattrack (rep, 1));
		printf ("%d.%d -> %d.%d\n", track/HPC, track%HPC,
			rep/HPC, rep%HPC);
		if (! formatbad (track, rep)) {
			printf (MSG ("\nREASSIGNMENT ERROR -- FORMAT ABORTED\n",
				"\n  --  \n"));
			return (0);
		}
		reptab[i].btt_badcyl = track / HPC;
		reptab[i].btt_badhead = track % HPC;
		reptab[i].btt_newcyl = rep / HPC;
		reptab[i].btt_newhead = rep % HPC;
	}
	return (1);
}

getunit ()
{
	char line [80];

	printf (MSG ("\nEnter unit number: (0-7) [0] ",
		"\n  : (0-7) [0] "));
	gets (line);
	return (atoi (line));
}

init (u)
{
	register struct sccmd *p;
	register struct fmtcode *c;
	register struct fmtblock *b;
	int i;

	fmtmask = 0xc0;            /* c000 0000 0000 0000 */
	fmtmask <<= 56;

	fmtwaddr [1] = 0x80;
	fmtwaddr [1] <<= 48;

	devunit = chantab [hdchan] + u;
	for (p=fmttrack; p->cmd; ++p)
		p->unit = devunit;
	for (p=fmtbadtrack; p->cmd; ++p)
		p->unit = devunit;

	hdsense.unit = devunit;
	hdsense.addr = (int) hdsbuf;

	fmtbadtrack[0].addr = (int) &fmtmask;
	fmtbadtrack[1].addr = (int) &fmtcyl;
	fmtbadtrack[2].addr = (int) &fmtaddr;
	fmtbadtrack[3].addr = (int) &fmtbadtrack[2];
	fmtbadtrack[4].addr = (int) fmtwaddr;
	fmtbadtrack[5].addr = (int) &fmtaddr;

	fmttrack[0].addr = (int) &fmtmask;
	fmttrack[1].addr = (int) &fmtcyl;
	fmttrack[2].addr = (int) &fmtaddr;
	fmttrack[3].addr = (int) &fmttrack[2];
	fmttrack[4].addr = (int) fmtwaddr;
	fmttrack[5].addr = (int) &fmtaddr;
	fmttrack[6].addr = (int) &fmtwr[0];
	fmttrack[7].addr = (int) &fmtwr[1];
	fmttrack[8].addr = (int) &fmtwr[2];
	fmttrack[9].addr = (int) &fmtwr[3];
	fmttrack[10].addr = (int) &fmtwr[4];
	fmttrack[11].addr = (int) &fmtwr[5];
	fmttrack[12].addr = (int) &fmtwr[6];
	fmttrack[13].addr = (int) &fmtwr[7];
	fmttrack[14].addr = (int) &fmtwr[8];
	fmttrack[15].addr = (int) &fmtwr[9];
	fmttrack[16].addr = (int) &fmtbuf;
	fmttrack[17].addr = (int) &fmtrd[0];
	fmttrack[18].addr = (int) &fmtrd[1];
	fmttrack[19].addr = (int) &fmtrd[2];
	fmttrack[20].addr = (int) &fmtrd[3];
	fmttrack[21].addr = (int) &fmtrd[4];
	fmttrack[22].addr = (int) &fmtrd[5];
	fmttrack[23].addr = (int) &fmtrd[6];
	fmttrack[24].addr = (int) &fmtrd[7];
	fmttrack[25].addr = (int) &fmtrd[8];
	fmttrack[26].addr = (int) &fmtrd[9];

	for (b=fmtwr; b<fmtwr+BPT; ++b) {
		b->marker = ((b-fmtwr) + 1) << 24 | (131 * 9);
		for (c=b->code; c<b->code+16; ++c)
			*c = fmtcode;
		b->checksum = ~(unsigned)0;
		b->nblock = makenblock (0);
		b->time = 0xd8;
		b->time <<= 48;
		b->reserved = 0xd8;
		b->reserved <<= 40;
	}
	for (i=0; i<NREPTRACKS; ++i);
		reptrack [i] = TFREE;
}

makenblock (n)
{
	int b;

	b = 0xd8;
	b <<= 56;
	return (b | n << 16);
}

getname (s)
char *s;
{
	/*    */
	printf (MSG ("\nVolume name: [%s] ",
		"\n : [%s] "), DFLTVOLNAME);
	gets (s);
	if (! s [0]) {
		strcpy (s, DFLTVOLNAME);
		return (0);
	}
}

findrep ()
{
	/*     */
	/* 0    */
	int i;

	for (i=0; i<NREPTRACKS; ++i);
		if (reptrack [i] == TFREE) {
			reptrack [i] = TUSED;
			return (i+NTRACKS);
		}
	return (0);
}

wrlabel (volname, u)
char *volname;
{
	/*    */
	static char unitname [] = "hd(0)";
	register struct vl_fixed *lbl;
	register struct pt_entry *pt;
	register struct btt_entry *btt;
	char name [80];
	int i, n;

	unitname [3] = '0' + u;
	if ((i = open (unitname, 1)) < 0)
		return;
	for (n=0; n<VLABELSZ*K/W; ++n)
		buf [n] = 0;
	lbl = (struct vl_fixed *) buf;
	store8name (volname, &lbl->vl_name); /* volume name */
	lbl->vl_magic = VL_MAGIC;        /* magic word */
	lbl->vl_fmttime = 0;             /* formatting time */
	lbl->vl_systemid = 1;            /* system where format was done */
	lbl->vl_revision = 0;            /* volume label revision */
	lbl->vl_version = 1;             /* volume label version */
	lbl->vl_size = NBLOCKS-2*VLABELSZ; /* volume size */
	lbl->vl_vlsize = VLABELSZ;       /* volume label size in blocks */
	lbl->vl_blksize = 7;             /* log2 (block size) */
	lbl->vl_model = 2;               /* storage media model */
	lbl->vl_vlcopy = NBLOCKS-VLABELSZ; /* block address of label copy */
	lbl->vl_restrack = NTRACKS;      /* 1st reserved track # */
	lbl->vl_nreserved = NREPTRACKS;  /* number of reserved tracks */
	lbl->vl_ptntab = 6+NREPTRACKS;   /* partition table address */
	lbl->vl_maxptn = 256;            /* maximum number of partitions */

	name [0] = name [1] = 0;
	strcpy (name+2, volname);
	/* strcat (name, EXTVOL); */

	pt = (struct pt_entry *) (buf + lbl->vl_ptntab);
	storename (name, pt);           /* partition name */
	pt->pt_offset = 0;              /* partition offset */
	pt->pt_version = 1;             /* partition version */
	pt->pt_size = NBLOCKS;          /* blocks in partition */

	strcpy (name, volname);
	strcat (name, EXTLBL);

	++pt;
	storename (name, pt);           /* partition name */
	pt->pt_offset = 0;              /* partition offset */
	pt->pt_version = 1;             /* partition version */
	pt->pt_size = VLABELSZ;         /* blocks in partition */

	/*    */
	btt = (struct btt_entry *) (buf + 6);
	for (n=0; n<nbad; ++n)
		*btt++ = reptab [n];

	write (i, (char *) buf, VLABELSZ*K);
	close (i);
}

storename (s, p)
char *s;
int *p;
{
	int n, b;

	p[0] = 0;
	p[1] = p[1] << 32 >> 32;
	b = 1;
	for (n=0; n<8 && (b || *s); ++s, ++n) {
		if (*s)
			b = 0;
		p[0] |= *s << (56-8*n);
	}
	for (n=0; n<4 && *s; ++s, ++n)
		p[1] |= *s << (56-8*n);
}

store8name (s, p)
char *s;
int *p;
{
	int n;

	*p = 0;
	for (n=0; n<8 && *s; ++s, ++n)
		*p |= *s << (56-8*n);
}

fmtio (prog)
struct sccmd *prog;
{
	int retry, csw, csb;
# ifdef DEBUG
	int caw, ccw;
# endif

	retry = 0;
repeat:
	csw = scwait (hdchan, prog);
	switch (csw>>1 & 7) {
	case 2:         /*   */
		break;
	case 3:         /* .   */
		printf (MSG ("format: bad unit address\n", "format: .  \n"));
		exit (1);
	case 4:         /*    */
		printf (MSG ("format: unit not found\n", "format:   \n"));
		exit (1);
	case 6:         /* .   */
		printf (MSG ("format: RAM error\n", "format:  \n"));
		exit (1);
	case 7:         /*    */
		printf (MSG ("format: bad transfer\n", "format:  \n"));
		exit (1);
	case 0:
		if ((csw >> 32 & 0xff) != devunit)
			break;
		if (csw & 0x1f80)
			break;
		csb = csw >> 16 & 0xffff;
		if (csb == 0x0804) {
done:                   /*   */
			_in_ (SC_CSW (hdchan) | SCA_RESET | SCA_NOHALT);
			return (0);
		}
		if (csb == 0x4a04) {
unitbusy:               /*   */
			_in_ (SC_CCW (hdchan) | SCA_RESET|SCA_NOHALT|SCA_SBLOCK);
			goto repeat;
		}
		break;
	case 1:
		if ((csw >> 24 & 0xff) != devunit)
			break;
		if (csw & 0x1f80)
			break;
		csb = csw >> 16 & 0xff;
		if (csb == 0x0c || csb == 0x08)
			goto done;
		if (csb == 0x4e)
			goto unitbusy;
		break;
	}
# ifdef DEBUG
	ccw = _in_ (SC_CCW (hdchan) | SCA_NOHALT);      /*  */
	caw = _in_ (SC_CAW (hdchan) | SCA_NOHALT);      /*  */
# endif
	_in_ (SC_CCW (hdchan) | SCA_RESET | SCA_NOHALT); /* .   */

	/*   */
	scwait (hdchan, &hdsense);

	_in_ (SC_CSW (hdchan) | SCA_RESET | SCA_NOHALT); /*   */
# ifdef DEBUG
	printf ("\n=%w  =%w  =%w\n", ccw, csw, caw);
	printf ("0=%w  1=%w  2=%w\n", hdsbuf[0], hdsbuf[1], hdsbuf[2]);
# endif
	/* if ((hdsbuf [0] & 0xff) == 0x53) */
	if (retry++ <= MAXRETRY)
		goto repeat;
	return (-1);
}

formattrack (track, repflag)
{
	/*   */
	/*     */
	int c, h, i;


	/* 1)  fmtaddr, fmtwaddr, fmtcyl */
	c = track / HPC;        /*   */
	h = track - c * HPC;    /*   */
	fmtcyl = c<<32 | h<<16;
	fmtaddr = fmtcyl << 16;
	if (repflag) {
		/*    */
		fmtwaddr [0] = 0x01;
		fmtwaddr [0] <<= 56;
	} else
		fmtwaddr [0] = fmtcyl << 8 | 0x800080;

	/* 2)   marker  nblock  fmtwr [i] */
	for (i=0; i<BPT; ++i) {
		fmtwr[i].marker = fmtaddr | (i + 1) << 24 | (131 * 9);
		fmtwr[i].nblock = makenblock (track*BPT + i + 1);
		c = (_nbits_ (fmtwr[i].nblock << 8 >> 32) & 1) << 7;
		c |= (_nbits_ (fmtwr[i].nblock << 40) & 1) << 6;
		fmtwr[i].time = (c ^ 0xd8) << 48;
	}
	/* 3)  fmtio (fmttrack) */
	if (fmtio (fmttrack) < 0)
		return (0);

	/* 4)  fmtrd  fmtwr */
	for (i=0; i<BPT; ++i)
		if (bcmp ((char *) &fmtwr[i], (char *) &fmtrd[i],
		    sizeof (struct fmtblock))) {
# ifdef DEBUG
			printf (MSG ("\tchsum\n", "\t\n"));
# endif
			return (0);
		}

	/* 5)    */
	return (1);
}

formatbad (track, rep)
{
	/*   */
	/*     */
	int c, h;

	/* 1)  fmtaddr, fmtwaddr, fmtcyl */
	c = track / HPC;        /*   */
	h = track - c * HPC;    /*   */
	fmtcyl = c<<32 | h<<16;
	fmtwaddr [0] = 0x02;
	fmtwaddr [0] <<= 56;
	fmtwaddr [0] |= fmtcyl << 8 | 0x800080;

	c = rep / HPC;          /*     */
	h = rep - c * HPC;      /*     */
	fmtaddr = (c<<32 | h<<16) << 16;

	/* 2)  fmtio (fmtbadtrack) */
	if (fmtio (fmtbadtrack) < 0)
		return (0);

	/* 3)    */
	return (1);
}
