/*
 *  -  -
 * ==============================
 *   808 x 19 x 3 x 4k  
 *
 *    -
 * -------------------------------------------
 *
 * (1)  .  - 
 *   
 *
 *              YY 07 64 0000 AAAAAA
 *
 *      YY -  
 *
 *              .       YY+
 *                        
 *           ------------------------------
 *              0               38
 *              1               d8
 *              2               58
 *              3               80
 *
 *      AAAAAA - .  
 *
 *              0000 0 00 XXXX
 *
 *       -  , 0-814
 *       -  , 0-18
 *
 * (2)   
 *
 *              YY 31 54 0000 AAAAAA
 *
 *      AAAAAA -  , , 
 *
 *              0 00 00 0000
 *
 *       -  , 0-814
 *       -  , 0-18
 *       -   (), 1-3
 *
 * (3)    
 *
 *              YY 08 0c 0000 AAAAAA
 *
 *      AAAAAA -   
 *
 * (4)  
 *
 *              YY ZZ 04 0200 AAAAAA
 *
 *      ZZ - : =06, =05
 *      AAAAAA -   , 131 
 *
 *  (1)-(4)      .
 *     ,  (1)   
 *
 *    43  =0.
 */

# include "param.h"
# include "inode.h"
# include "fs.h"

# include "saio.h"
# include "scio.h"
# include "svsb.h"

# define DEBUG

# define HPBSIZE        4096            /* block size */
# define W              ((int) sizeof (int))

# define HPC            19              /* heads per cylinder */
# define BPT            3               /* blocks per track */
# define NCYL           808             /* number of cylinders in use */

# define BPC            (HPC*BPT)       /* blocks per cylinder */
# define NBLOCKS        (NCYL*HPC*BPT)

# define MAXRETRY       5               /* max number of retry */

# define MAXCPSZ        16              /* .    */

struct sccmd hpsense = {
/*    addr    count   flg     cmd     unit    */
/* &hpsbuf */           0,      3,      0,      4,      0,
};

int hpsbuf [3];

# ifdef CORR
struct sccmd hpcorr [3] = {
/*   . . addr    count   flg     cmd     unit    */
/* &hpsbuf[1] */        0,      0,      0x54,   0x31,   0,
/* .-1 */               0,      0,      0x04,   0x08,   0,
/*  */               0,      0,      0,      0x08,   0,
};
# endif

struct sccmd hpsample [4] = {
/*           addr    count   flg     cmd     unit    */
/* &hpcyl */            0,      0,      0x64,   0x07,   0,
/* &hpblock */          0,      0,      0x54,   0x31,   0,
/* .-1 */               0,      0,      0x0c,   0x08,   0,
/* &buf */              0,      HPBSIZE/W, 0x04, 0x06,   0,
};

struct sccmd hpprog [4*MAXCPSZ];
int nprog;                      /*      */

int hpchan = 0;                 /*    */

int hpcyl [MAXCPSZ];            /* 0000 0ccc 00hh xxxx */
int hpblock [MAXCPSZ];          /* 0ccc 00hh bb00 0000 */

int hpcsw;                      /* channel status word */
int hpunit;                     /* unit address for channel program */

extern chantab [];

hpopen (io)
register struct iob *io;
{
	static firsttime = 1;

	io->i_unit &= 7;
	screset (hpchan);

	if (! io->i_dsz)
		io->i_dsz = NBLOCKS;
	if (! firsttime)
		return;

	hpsense.addr = (int) hpsbuf;
	firsttime = 0;
}

hpstrategy (io, func)
register struct iob *io;
{
	/* io->i_ma -    */
	/* io->i_cc -     */
	/* io->i_bn -   */
	int n, i;

	if (io->i_bn < 0 || io->i_bn >= io->i_boff+io->i_dsz)
		return (0);
	n = io->i_cc / HPBSIZE;
	if (io->i_cc != n*HPBSIZE) {
		printf (MSG ("hp: bad block length %d\n",
			"hp:    %d\n"), io->i_cc);
		return (-1);
	}
	if (io->i_bn+n > io->i_boff+io->i_dsz)
		n = io->i_dsz - io->i_bn;
	if (hprw (hpchan, io->i_unit, func==WRITE ? 0 : 1, io->i_bn, n, io->i_ma) < 0)
		return (-1);
	return (n * HPBSIZE);
}

/* ARGSUSED */
hpioctl (io, cmd, arg)
struct iob *io;
int cmd;
caddr_t arg;
{
	return (ECMD);
}

int hprw (chan, unit, rd, nblock, sz, addr)
int *addr;
{
	if (nblock<0 || nblock+sz>NBLOCKS) {
		printf (MSG ("hp: bad block number %d:%d\n",
			"hp:    %d:%d\n"), nblock, sz);
		return (-1);
	}
	hpsetup (chan, unit, rd, nblock, sz, addr);
	if (hdio (chan, hpprog) < 0)
		return (-1);
	return (0);
}

hpsetup (chan, unit, rd, nblock, sz, addr)
int *addr;
{
	int c, h, b, i;

	/*    */
	nprog = 0;
	for (i=0; i<sz; ++i, ++nblock) {
		c = nblock / BPC;       /*   */
		b = nblock - c * BPC;
		h = b / BPT;            /*   */
		b = b - h * BPT + 1;    /*   */

		hpcyl [i] = c<<32 | h<<16 | b<<8;
		hpblock [i] = hpcyl [i] << 16;

		if (! i || (hpcyl[i] ^ hpcyl[i-1]) >> 16) {
			/*     */
			hpprog[nprog] = hpsample[0];
			hpprog[nprog++].addr = (int) &hpcyl[i];
		}
		hpprog[nprog] = hpsample[1];
		hpprog[nprog++].addr = (int) &hpblock[i];
		hpprog[nprog] = hpsample[2];
		hpprog[nprog].addr = (int) &hpprog[nprog-1];
		hpprog[++nprog] = hpsample[3];
		hpprog[nprog].addr = (int) (addr + i*(HPBSIZE/W));
		hpprog[nprog++].cmd = rd ? 6 : 5;
	}

	/*    */
	hpunit = chantab [chan & 3] + unit;
	hpsense.unit = hpunit;
	for (i=0; i<nprog; ++i)
		hpprog[i].unit = hpunit;

	/*    */
	hpprog[nprog-1].flg &= ~4;
}
