/*
 *  -  -
 * ===============================
 *   808 x 19 x 3 x 4k  
 *
 *    815   19 .
 *   - 13440 .
 *    - 208,118,400  (198 Mb).
 *      
 *  92+13+7+49+11+7 = 179 .
 *   N    L .
 *     
 * 59+11+7+49+7 = 133 .
 *
 *    N=3, L=4096 ,
 *   808*19*12k = 184,224k (179 Mb).
 *
 * (L + 133) * N + 179 = 12866 < 13440
 *
 *     
 * ----------------------------------------------
 *
 * (1)  
 *
 *              YY 1f 14 0000 AAAAAA
 *
 *      AAAAAA -  
 *
 *              c000 0000 0000 0000
 *
 * (2)  
 *
 *              YY 07 64 0000 AAAAAA
 *
 *      AAAAAA -  
 *
 *              0000 0 00 XXXX
 *
 *       -  , 0-813
 *       -  , 0-18
 *
 * (3)  . 
 *
 *              YY 39 44 0000 AAAAAA
 *
 *      AAAAAA -  
 *
 *              0 00 0000 0000
 *
 * (4)    
 *
 *              YY 08 04 0000 AAAAAA
 *
 *      AAAAAA -   
 *
 * (5)  . 
 *
 *              YY 19 34 0001 AAAAAA
 *
 *      AAAAAA -  
 *
 *              000 00 80 0080
 *              0080 0000 0000 0000
 *
 * (6)  
 *
 *              YY 15 04 0001 AAAAAA
 *
 *      AAAAAA -  ,    (3)
 *
 * (7) - (9) 3       
 *
 *              YY 1d 04 0200 AAAAAA
 *
 *      AAAAAA -    512 .
 *        3-    .
 *
 * (10)  . 
 *
 *              YY 1a 54 0000 AAAAAA
 *
 *      AAAAAA -    1 
 *
 * (11) - (13) 3       
 *
 *              YY 1e 04 0200 AAAAAA
 *
 *      AAAAAA -    512  (4096 ).
 *        3-    .
 *
 *
 *   
 * --------------------------
 *
 * (1) 8  -                            0
 *
 *              0 00 000 1000
 *                              ||
 *                             4096
 *
 * (2)  512                     1-512
 *
 *              5555 5555 5555 5555
 *              aaaa aaaa aaaa aaaa
 *
 *    
 * -----------------------------
 *
 *      0 00 0 00
 *          |         |
 *          
 *           
 *
 *
 *  
 * ------------------
 *
 * 1)    (3)  (6) (addr)    
 *
 * 2)    (5) (waddr)  
 *
 *      020 00 ...
 *      ~~
 * 3)   (7) - (13)
 *
 *
 *   
 * -------------------------
 *
 * 1)   (5):
 *
 *      0100 0000 0000 0000
 *      ...
 *
 * 2)   (2) -   
 *
 * 3)   (3)  (6) -   
 */

# include "svsb.h"
# include "scio.h"

# define K              1024
# define W              ((int) sizeof (int))
# define HPBSIZE        4096            /* block size */

# define HPC            19              /*    */
# define BPT            3               /*    */
# define NCYL           808             /*   */
# define NPHYSCYL       814             /*  ,  815 */

# define BPC            (HPC*BPT)       /*     */
# define NBLOCKS        (NCYL*HPC*BPT)  /*   */
# define NTRACKS        (NCYL*HPC)      /*   */
# define NPHYSTRACKS    (NPHYSCYL*HPC)  /*   */
# define NREPTRACKS     ((NPHYSCYL-NCYL)*HPC)   /*   */

# define MAXRETRY       10              /* max number of retry */

# define DEBUG

/*    */

# define TFREE  0                       /*  */
# define TUSED  1                       /*  */
# define TBAD   -1                      /*   */

int fmtcode = 0x5555555555555555;

struct fmtblock {
	int marker;
	int block [HPBSIZE/W];
};

static struct sccmd fmtbadtrack [] = {
/*     addr    count   flg     cmd     unit    */
/* &fmtmask */          0,      0,      0x14,   0x1f,   0,
/* &fmtcyl */           0,      0,      0x64,   0x07,   0,
/* &fmtaddr */          0,      0,      0x44,   0x39,   0,
/* &fmtbadtrack[2] */   0,      0,      0x04,   0x08,   0,
/* &fmtwaddr */         0,      1,      0x34,   0x19,   0,
/* &fmtaddr */          0,      1,      0,      0x15,   0,
			0,      0,      0,      0,      0,
};

static struct sccmd fmttrack [] = {
/*       addr    count   flg     cmd     unit    */
/* &fmtmask */          0,      0,      0x14,   0x1f,   0,
/* &fmtcyl */           0,      0,      0x64,   0x07,   0,
/* &fmtaddr */          0,      0,      0x44,   0x39,   0,
/* &fmttrack[2] */      0,      0,      0x04,   0x08,   0,
/* &fmtwaddr */         0,      1,      0x34,   0x19,   0,
/* &fmtaddr */          0,      1,      0x04,   0x15,   0,
/* &fmtwr[0] */         0,      0x200,  0x04,   0x1d,   0,
/* &fmtwr[1] */         0,      0x200,  0x04,   0x1d,   0,
/* &fmtwr[2] */         0,      0x200,  0x04,   0x1d,   0,
/* &fmtbuf */           0,      0,      0x54,   0x1a,   0,
/* &fmtrd[0] */         0,      0x200,  0x04,   0x1e,   0,
/* &fmtrd[1] */         0,      0x200,  0x04,   0x1e,   0,
/* &fmtrd[2] */         0,      0x200,  0x00,   0x1e,   0,
			0,      0,      0,      0,      0,
};

int fmtmask;            /* c000 0000 0000 0000 */
int fmtcyl;             /* 0000 0 00 XXXX */
int fmtaddr;            /* 0 00 0000 0000 */
int fmtwaddr [2];       /* 000 00 80 0080  0080 0000 0000 0000 */

struct fmtblock fmtwr [BPT];
struct fmtblock fmtrd [BPT];

int fmtbuf;

int badtrack [NREPTRACKS];      /*      */
int nbad;                       /*    */

int reptrack [NREPTRACKS];      /*    */

int unit;                       /*    */
int devunit;                    /*    */

extern hdchan;                  /*    */
extern hdsbuf [];
extern chantab [];
extern struct sccmd hdsense;

yes ()
{
	char rep [80];
	int r;

	printf ("? (y, n, , ) [] ");
	gets (rep);
	r = rep [0];
	if (r=='y' || r=='Y' || r=='' || r=='')
		return (1);
	if (r=='n' || r=='N' || r=='' || r=='')
		return (-1);
	return (0);
}

main ()
{
	printf (MSG ("\nFORMAT 4K %s    %s\n", "\n 4K %s    %s\n"),
		BOOTVERSION, MSG (LCOPYRIGHT, RCOPYRIGHT));
	printf (MSG ("\nUsing this program you may OVERWRITE information on your hard disks.\n",
		"\n          .\n"));
	printf (MSG ("\nIt is strongly recommended to TURN unnecessary disks 'READ-ONLY'.\n",
		"\n      .\n"));
	printf (MSG ("Do you want to continue",
		""));
	if (yes () != 1)
		return;
	unit = getunit ();
	nbad = 0;
	printf (MSG ("\nFormat unit %d", "\n  %d"),
		unit);
	if (yes () != 1)
		return;
	/*      */
	init (unit);

	printf (MSG ("\nINITIAL FORMATTING\n", "\n \n"));
	if (! format1 ())
		return;

	if (nbad) {
		printf (MSG ("\nBAD TRACKS REMAPPING\n", "\n\n"));
		if (! format2 ())
			return;
	}
	printf (MSG ("\nFormat completed.\n", "\n .\n"));
}

format1 ()
{
	int track;

	/*        */
	for (track=0; track<NPHYSTRACKS; ++track) {
		idle (1);
		if (! (track % HPC))
			printf ("\r%d", track/HPC);
		if (! formattrack (track, 0)) {
			printf ("\r%d.%d\t", track/HPC, track%HPC);
			printf (MSG ("\t***** Bad track\n",
				"\t*****  \n"));
			if (track >= NTRACKS)
				/*    */
				reptrack [track-NTRACKS] = TBAD;
			else {
				if (nbad >= NREPTRACKS) {
					printf (MSG ("\nTOO MANY BAD TRACKS -- FORMAT ABORTED\n",
						"\n    --  \n"));
					return (0);
				}
				badtrack [nbad++] = track;
			}
			printf ("%d", track/HPC);
		}
	}
	return (1);
}

format2 ()
{
	int track, rep, i;

	/*    */
	for (i=0; i<nbad; ++i) {
		track = badtrack [i];
		do
			if (! (rep = findrep ())) {
				printf (MSG ("\nBAD TRACK TABLE OVERFLOW -- FORMAT ABORTED\n",
					"\n     --  \n"));
				return (0);
			}
		while (! formattrack (rep, 1));
		printf ("%d.%d -> %d.%d\n", track/HPC, track%HPC,
			rep/HPC, rep%HPC);
		if (! formatbad (track, rep)) {
			printf (MSG ("\nREASSIGNMENT ERROR -- FORMAT ABORTED\n",
				"\n  --  \n"));
			return (0);
		}
	}
	return (1);
}

getunit ()
{
	char line [80];

	printf (MSG ("\nEnter unit number: (0-7) [0] ",
		"\n  : (0-7) [0] "));
	gets (line);
	return (atoi (line));
}

init (u)
{
	register struct sccmd *p;
	register *c;
	register struct fmtblock *b;
	int i;

	fmtmask = 0xc0;            /* c000 0000 0000 0000 */
	fmtmask <<= 56;

	fmtwaddr [1] = 0x80;
	fmtwaddr [1] <<= 48;

	devunit = chantab [hdchan] + u;
	for (p=fmttrack; p->cmd; ++p)
		p->unit = devunit;
	for (p=fmtbadtrack; p->cmd; ++p)
		p->unit = devunit;

	hdsense.unit = devunit;
	hdsense.addr = (int) hdsbuf;

	fmtbadtrack[0].addr = (int) &fmtmask;
	fmtbadtrack[1].addr = (int) &fmtcyl;
	fmtbadtrack[2].addr = (int) &fmtaddr;
	fmtbadtrack[3].addr = (int) &fmtbadtrack[2];
	fmtbadtrack[4].addr = (int) fmtwaddr;
	fmtbadtrack[5].addr = (int) &fmtaddr;

	fmttrack[0].addr = (int) &fmtmask;
	fmttrack[1].addr = (int) &fmtcyl;
	fmttrack[2].addr = (int) &fmtaddr;
	fmttrack[3].addr = (int) &fmttrack[2];
	fmttrack[4].addr = (int) fmtwaddr;
	fmttrack[5].addr = (int) &fmtaddr;
	fmttrack[6].addr = (int) &fmtwr[0];
	fmttrack[7].addr = (int) &fmtwr[1];
	fmttrack[8].addr = (int) &fmtwr[2];
	fmttrack[9].addr = (int) &fmtbuf;
	fmttrack[10].addr = (int) &fmtrd[0];
	fmttrack[11].addr = (int) &fmtrd[1];
	fmttrack[12].addr = (int) &fmtrd[2];

	for (b=fmtwr; b<fmtwr+BPT; ++b) {
		b->marker = ((b-fmtwr) + 1) << 24 | HPBSIZE;
		for (c=b->block; c<b->block+HPBSIZE/W; ) {
			*c++ = fmtcode;
			*c++ = ~fmtcode;
		}
	}
	for (i=0; i<NREPTRACKS; ++i);
		reptrack [i] = TFREE;
}

findrep ()
{
	/*     */
	/* 0    */
	int i;

	for (i=0; i<NREPTRACKS; ++i);
		if (reptrack [i] == TFREE) {
			reptrack [i] = TUSED;
			return (i+NTRACKS);
		}
	return (0);
}

fmtio (prog)
struct sccmd *prog;
{
	int retry, csw, csb;
# ifdef DEBUG
	int caw, ccw;
# endif

	retry = 0;
repeat:
	csw = scwait (hdchan, prog);
	switch (csw>>1 & 7) {
	case 2:         /*   */
		break;
	case 3:         /* .   */
		printf (MSG ("format: bad unit address\n", "format: .  \n"));
		exit (1);
	case 4:         /*    */
		printf (MSG ("format: unit not found\n", "format:   \n"));
		exit (1);
	case 6:         /* .   */
		printf (MSG ("format: RAM error\n", "format:  \n"));
		exit (1);
	case 7:         /*    */
		printf (MSG ("format: bad transfer\n", "format:  \n"));
		exit (1);
	case 0:
		if ((csw >> 32 & 0xff) != devunit)
			break;
		if (csw & 0x1f80)
			break;
		csb = csw >> 16 & 0xffff;
		if (csb == 0x0804) {
done:                   /*   */
			_in_ (SC_CSW (hdchan) | SCA_RESET | SCA_NOHALT);
			return (0);
		}
		if (csb == 0x4a04) {
unitbusy:               /*   */
			_in_ (SC_CCW (hdchan) | SCA_RESET|SCA_NOHALT|SCA_SBLOCK);
			goto repeat;
		}
		break;
	case 1:
		if ((csw >> 24 & 0xff) != devunit)
			break;
		if (csw & 0x1f80)
			break;
		csb = csw >> 16 & 0xff;
		if (csb == 0x0c || csb == 0x08)
			goto done;
		if (csb == 0x4e)
			goto unitbusy;
		break;
	}
# ifdef DEBUG
	ccw = _in_ (SC_CCW (hdchan) | SCA_NOHALT);      /*  */
	caw = _in_ (SC_CAW (hdchan) | SCA_NOHALT);      /*  */
# endif
	_in_ (SC_CCW (hdchan) | SCA_RESET | SCA_NOHALT); /* .   */

	/*   */
	scwait (hdchan, &hdsense);

	_in_ (SC_CSW (hdchan) | SCA_RESET | SCA_NOHALT); /*   */
# ifdef DEBUG
	printf ("\n=%w  =%w  =%w\n", ccw, csw, caw);
	printf ("0=%w  1=%w  2=%w\n", hdsbuf[0], hdsbuf[1], hdsbuf[2]);
# endif
	/* if ((hdsbuf [0] & 0xff) == 0x53) */
	if (retry++ <= MAXRETRY)
		goto repeat;
	return (-1);
}

formattrack (track, repflag)
{
	/*   */
	/*     */
	int c, h, i;

	/* 1)  fmtaddr, fmtwaddr, fmtcyl */
	c = track / HPC;        /*   */
	h = track - c * HPC;    /*   */
	fmtcyl = c<<32 | h<<16;
	fmtaddr = fmtcyl << 16;
	if (repflag) {
		/*    */
		fmtwaddr [0] = 0x01;
		fmtwaddr [0] <<= 56;
	} else
		fmtwaddr [0] = fmtcyl << 8 | 0x800080;

	/* 2)   marker  nblock  fmtwr [i] */
	for (i=0; i<BPT; ++i)
		fmtwr[i].marker = fmtaddr | (i + 1) << 24 | HPBSIZE;

	/* 3)  fmtio (fmttrack) */
	if (fmtio (fmttrack) < 0)
		return (0);

	/* 4)  fmtrd  fmtwr */
	for (i=0; i<BPT; ++i)
		if (bcmp ((char *) &fmtwr[i], (char *) &fmtrd[i],
		    sizeof (struct fmtblock))) {
# ifdef DEBUG
			printf (MSG ("\tchsum\n", "\t\n"));
# endif
			return (0);
		}

	/* 5)    */
	return (1);
}

formatbad (track, rep)
{
	/*   */
	/*     */
	int c, h;

	/* 1)  fmtaddr, fmtwaddr, fmtcyl */
	c = track / HPC;        /*   */
	h = track - c * HPC;    /*   */
	fmtcyl = c<<32 | h<<16;
	fmtwaddr [0] = 0x02;
	fmtwaddr [0] <<= 56;
	fmtwaddr [0] |= fmtcyl << 8 | 0x800080;

	c = rep / HPC;          /*     */
	h = rep - c * HPC;      /*     */
	fmtaddr = (c<<32 | h<<16) << 16;

	/* 2)  fmtio (fmtbadtrack) */
	if (fmtio (fmtbadtrack) < 0)
		return (0);

	/* 3)    */
	return (1);
}
