/*****************************************************************
 *                       
 *****************************************************************
 *
 *    :        0.
 *                   - .
 *
 *________________________________________________________________
 */

# include <conio.h>
# include <dos.h>
# include "nandef.h"
# include "extend.h"				/*    */

# define in			inp
# define out			outp

# define BUFSZ 		(4*1024)

/* defines for second 8237A DMA controller */

# define DMA_PG6    		0x89		/* channel 6 page */
# define DMA_CNT6		0xca		/* count */
# define DMA_OFF6		0xc8		/* address */

# define DMA_PG7		0x8a		/* channel 7 page */
# define DMA_CNT7		0xce		/* count */
# define DMA_OFF7		0xcc		/* address */

# define DMA_CSR		0xd0		/* control & status */
# define DMA_REQ		0xd2		/* request */
# define DMA_MASK		0xd4		/* mask */
# define DMA_MODE		0xd6		/* mode */
# define DMA_CLRFF		0xd8		/* flip flop */
# define DMA_TMP		0xda		/* master clear & tmp */
# define DMA_CLRMASK		0xdc		/* clear mask */
# define DMA_ALLMASK		0xde		/* all mask */

# define DMAM_WRITE		4		/* write mode */
# define DMAM_READ		8		/* read mode */

# define DMA_CHAN6		2		/* 6  dma   */
# define DMA_CHAN7		3		/* 7  dma   */

/*    */

# define P_ICR         	port            /*   - */
# define P_INTR        	port            /*   */
# define P_OCR         	(port+1)        /*   - */
# define P_SR          	(port+1)        /*   */
# define P_UCR         	(port+2)        /*    */
# define P_UDR         	(port+3)        /*    */

/*    */

# define R_URDY		0x20		/*   1- */
# define R_UDATA 		0x10            /*   1- */
# define R_REOT		0x08            /*   */
# define R_RRDY		0x04            /*   */
# define R_TEOT		0x02            /*   */
# define R_TRDY		0x01            /*   */

/*    */

# define S_TERR		0x01            /*    */
# define S_TPARITY		0x02            /*     */
# define S_TLENGTH  		0x04            /*     */
# define S_RERR		0x08            /*    */

# define S_UIACK		0x10            /*     */
# define S_UOACK		0x20            /*    1- */
# define S_UID0		0x40            /*  0 */
# define S_UID1		0x80            /*  1 */

# define S_UID	   		(S_UID0|S_UID1) /*  */

# define PHYSADDR(p)		((unsigned) (p) + (((unsigned long) (p) >> 12) & 0xffff0L))

# define BYTE			unsigned char

# define INTCTLR1		0x20
# define INTCTLR2		0xa0

# define SYSTIMER 0x40		/* 55 ms hardware timer */

int intrflag;

void interrupt intrcatcher ();
void (interrupt *savevect) ();

int idma;               	/* input DMA channel number */
int odma;               	/* output DMA channel number */

int port;               	/* port number */
int irq;                	/* hardware IRQ number */

long randx;

short fillbuf [BUFSZ];
unsigned char inbuf [BUFSZ];
unsigned char outbuf [BUFSZ];

int buflen;
int fillmode;
int usercode;

long lpms;			/* loops per millisecond */

int dmacnt [] = { 0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xce };

int intvecnum [] = {
	0x8, 0x9, 0x71, 0xB, 0xC, 0xD, 0xE, 0xF,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
};

char hexdigit [16] = {
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'a', 'b', 'c', 'd', 'e', 'f',
};

int dma6 (), dma7 ();
long computelpms ();

/*________________________________________________________________
 *
 *                I.      UCCR.
 *________________________________________________________________
 *
 *  1. :  U0_UCCR()
 *
 *     :    UCCR,  .
 *      : 
 *      : 
 *________________________________________________________________
 *
 *  2. :  W_UCCR(p1)
 *
 *     :     UCCR,  .
 *      :
 *      p1 - 8 .  p1  = 'xxxxxxxx' x=0,1
 *      : 
 *________________________________________________________________
 *
 *  3. :  RAZ_V(p1)
 *
 *     : / ..
 *      :
 *      p1 - 1 .  p1  = '0'  -  .
 *                      p1 != '0' -  .
 *      : 
 *________________________________________________________________
 *
 *  4. :  RAZ_P(p1)
 *
 *     : / ..
 *      :
 *      p1 - 1 .  p1  = '0'  -  .
 *                      p1 != '0' -  .
 *      : 
 *________________________________________________________________
 *
 *  5. :  RM_V(p1)
 *
 *     : / ..
 *      :
 *      p1 - 1 .  p1  = '0'  -  .
 *                      p1 != '0' -  .
 *      : 
 *________________________________________________________________
 *
 *  6. :  RM_P(p1)
 *
 *     : / ..
 *      :
 *      p1 - 1 .  p1  = '0'  -  .
 *                      p1 != '0' -  .
 *      : 
 *________________________________________________________________
 */

CLIPPER U0_UCCR ()
{
	out (P_UCR, 0x2f);
	_ret ();
}

CLIPPER W_UCCR ()
{
	int reg = atob (_parc (1));

	out (P_UCR, reg);
	_ret ();
}

CLIPPER RAZ_V ()
{
	int set = _parc (1) [0] != '0';

	out (P_UCR, 4 | (set ? 0x10 : 0));
	_ret ();
}

CLIPPER RAZ_P ()
{
	int set = _parc (1) [0] != '0';

	out (P_UCR, 1 | (set ? 0x10 : 0));
	_ret ();
}

CLIPPER RM_V ()
{
	int set = _parc (1) [0] != '0';

	out (P_UCR, 8 | (set ? 0x10 : 0));
	_ret ();
}

CLIPPER RM_P ()
{
	int set = _parc (1) [0] != '0';

	out (P_UCR, 2 | (set ? 0x10 : 0));
	_ret ();
}

/*________________________________________________________________
 *
 *              II.      .
 *________________________________________________________________
 *
 *  1. :  W_DATA(p1)
 *
 *     :    .
 *      :
 *        .   8 . ( 'xxxxxxxx' x=0,1 )
 *      : 
 *________________________________________________________________
 *
 *  2. :  f = R_DATA()
 *
 *     :    .
 *      : 
 *      :
 *        .   8 . ( 'xxxxxxxx' x=0,1 )
 *________________________________________________________________
 *
 *  3. :  f = IOR2()
 *
 *     :    2.
 *      : 
 *      :
 *        .   8 . ( 'xxxxxxxx' x=0,1 )
 *________________________________________________________________
 *
 *  4. :  W_ID(p1)
 *
 *     :  .
 *      :
 *      p1 - 2 .  p1  = ''  -   ( =0,1 )
 *      : 
 *________________________________________________________________
 *
 *  5. :  f = R_ID()
 *
 *     :  ID.
 *      : 
 *      :
 *         .   2 . ( 'xx' x=0,1 )
 *________________________________________________________________
 */

CLIPPER W_DATA ()
{
	int byte = atob (_parc (1));

	out (P_UDR, byte);
	_ret ();
}

CLIPPER R_DATA ()
{
	static char buf [10];
	int byte;

	byte = in (P_UDR) & 0xff;
	btoa (buf, byte, 8);
	_retc (buf);
}

CLIPPER W_ID ()
{
	int byte = atob (_parc (1));

	out (P_UCR, byte<<6 & 0xc0 | 0x20);
	_ret ();
}

CLIPPER R_ID ()
{
	static char buf [4];
	int byte;

	byte = in (P_SR) >> 6 & 3;
	btoa (buf, byte, 2);
	_retc (buf);
}

CLIPPER IOR2 ()
{
	static char buf [10];
	int byte;

	byte = in (P_UCR) & 0xff;
	btoa (buf, byte, 8);
	_retc (buf);
}

/*________________________________________________________________
 *
 *                III.      ICR.
 *________________________________________________________________
 *
 *  1. :  U0_ICR()
 *
 *     :    ICR.
 *      : 
 *      : 
 *________________________________________________________________
 *
 *  2. :  ICR(p1)
 *
 *     :    ICR.
 *      :
 *      p1 - 3 .  p1  = 'xxx' x=0,1
 *      : 
 *________________________________________________________________
 */

CLIPPER U0_ICR ()
{
	out (P_ICR, 0);
	_ret ();
}

CLIPPER ICR ()
{
	int reg = atob (_parc (1));

	out (P_ICR, reg);
	_ret ();
}

/*________________________________________________________________
 *
 *                IV.      OCR.
 *________________________________________________________________
 *
 *  1. :  U0_OCR()
 *
 *     :    OCR.
 *      : 
 *      : 
 *________________________________________________________________
 *
 *  2. :  OCR(p1)
 *
 *     :    OCR.
 *      :
 *      p1 - 4 .  p1  = 'xxxx' x=0,1
 *      : 
 *________________________________________________________________
 */

CLIPPER U0_OCR ()
{
	out (P_OCR, 0);
	_ret ();
}

CLIPPER OCR ()
{
	int reg = atob (_parc (1));

	out (P_OCR, reg);
	_ret ();
}

/*________________________________________________________________
 *
 *           V.      .
 *________________________________________________________________
 *
 *  1. :  f = INTR()
 *
 *     :  INTR.
 *      : 
 *      :
 *         .   6 . ( 'xxxxxx' x=0,1 )
 *________________________________________________________________
 *
 *  2. :  f = SR()
 *
 *     :  SR (   ).
 *      : 
 *      :
 *         .   6 . ( 'xxxxxx' x=0,1 )
 *________________________________________________________________
 */

CLIPPER INTR ()
{
	static char buf [8];
	int byte;

	byte = in (P_INTR);
	btoa (buf, byte, 6);
	_retc (buf);
}

CLIPPER SR ()
{
	static char buf [8];
	int byte;

	byte = in (P_SR);
	btoa (buf, byte, 6);
	_retc (buf);
}

/*________________________________________________________________
 *
 *                VI.   .
 *________________________________________________________________
 *
 *  1. :  f = WAIT_INT(p1)
 *
 *     :     IRQ   
 *                   ,   p1 ().
 *                         ,
 *                    '1',   IRQ .
 *                          ,
 *                    '0',   IRQ .
 *      :
 *      p1 -  -   .  =0    
 *                         .
 *      :
 *         .   1 . ( 'x' x=0,1 )
 *         EOI ??  ??        != '0' -  
 *                                 = '0' - ,  
 */

CLIPPER WAIT_INT ()
{
	int timo = _parni (1);
	static char retbuf [4];
	long count;

	if (! lpms)
		lpms = computelpms ();

	count = (long) timo * lpms;

	intrflag = 0;
	in (P_UCR);
	setintr (irq);
	while (! intrflag && --count >= 0)	/* idle run */
		idlerun (0L);
	resetintr (irq);

	retbuf [0] = intrflag ? '1' : '0';
	retbuf [1] = 0;
	_retc (retbuf);
}

/*________________________________________________________________
 *
 *  2. :  f = RUN_DMA(p1,p2,p3)
 *
 *     :   DMA.
 *                  (  )??
 *      :
 *      p1 - 1 .  p1 = 'I' -  DMA   
 *                      p1 = 'O' -  DMA   
 *      p2 - 1 .  p2 = '0' -     
 *                      p2 = 'n' -     n 
 *      p3 - 1/2 .  p3 = '1', '2', ... , '64' -  
 *                                                    
 *      n       .
 *      :
 */

CLIPPER RUN_DMA ()              /* RUN_DMA (p1, p2, p3) */
{
	int inp = _parc (1) [0] == 'I';
	int offset = atox (_parc (2));
	int klen = atox (_parc (3));
	register i;

	buflen = klen * 1024;

	if (inp) {
		for (i=0; i<buflen; ++i)
			inbuf [i] = 0;
		(*(idma==6 ? dma6 : dma7)) (inbuf, buflen - offset, 0);
	} else
		(*(odma==6 ? dma6 : dma7)) (outbuf, buflen - offset, 1);
	_ret ();
}

/*________________________________________________________________
 *
 *  3. :  f = DMA_STATE(p1)
 *
 *     :     
 *                 DMA   .
 *      :
 *      p1 - 1 .  p1 = 'I' -  DMA   
 *                      p1 = 'O' -  DMA   
 *      :
 *                    INT ?
 */

CLIPPER DMA_STATE ()
{
	int inpflag = _parc (1) [0] == 'I';
	int portcnt = dmacnt [inpflag ? idma : odma];
	register unsigned len;

	out (DMA_CLRFF, 0);			/* clear flipflop */
	len = in (portcnt) & 0xff;              /* length in words */
	len |= (in (portcnt) << 8) & 0xff00;    /* length in words */
	_retni (len);
}

/*________________________________________________________________
 *
 *  4. :   SETUP(IOA, DMA, IRQ)
 *
 *     :     IOA, DMA  IRQ 
 *                   
 *      :
 *     1. IOA     -  .  3 .
 *     2. DMA     -  .  1 .
 *     3. IRQ     -  .  2 .
 */

CLIPPER SETUP ()        /* SETUP (IOA, DMA, IRQ) */
{
	port = atox (_parc (1));
	idma = atox (_parc (2));
	odma = idma==6 ? 7 : 6;
	irq = atoi (_parc (3));
	_ret ();
}

/*________________________________________________________________
 *
 *  4. :   FILL_SETUP(codtype, xx)
 *
 *     :      
 *                   .
 *      :
 *     1. codtype -  .  2 .
 *                       WCODUK  wcodbk:
 *         00 -   , 
 *         22 -    00            32 -    00
 *         23 -    55            33 -    FF
 *         24 -    xx            34 -    55
 *         25 -    .1         35 -    AA
 *         26 -    .0         36 -    xx
 *         27 -    .
 *         28 -    .
 *     2. xx      -  .  2 .
 *                  ,  .
 *
 *           :
 *
 *         1. codtype = 22,23
 *                :
 *          . 8  = '00'  '55' .
 *          . 2   2 . .
 *                :
 *             .
 *
 *         2. codtype = 24
 *                :
 *          . 8  =  xx.
 *          . 2   2 . .
 *                :
 *             .
 *
 *         3. codtype = 25,26,27,28
 *                    
 *               .   10-
 *                .
 *
 *         4.   codtype   .
 */

CLIPPER FILL_SETUP ()        /* FILL_SETUP (codtype, xx) */
{
	fillmode = atox (_parc (1));
	usercode = atox (_parc (2));

	fillarray (fillbuf, BUFSZ, fillmode, usercode);
	_ret ();
}

/*________________________________________________________________
 *
 *  4. :   FILL_BC(len)
 *
 *     :       .
 *
 *     1. len     -     ().
 */

CLIPPER FILL_BC ()        /* FILL_BC (len) */
{
	int length = _parni (1);
	register count;

	for (count=0; count<length; ++count)
		outbuf [count] = fillbuf [count];
	_ret ();
}

/*________________________________________________________________
 *
 *  4. :   FILL_UC(WCODUK)
 *
 *     :       .
 *
 *     1. WCODUK  -    .
 *                    WCODUK[i] -  .
 *                   10 .
 *                      .
 */

CLIPPER FILL_UC ()        /* FILL_SETUP (WCODUK) */
{
	int length;
	register i, count;
	char *p;

	length = _parinfa (1, 0);       /* length of WCODUK */

	for (count=0; count<length; ++count) {
		p = _parc (1, count+1);
		usercode = fillbuf [count];
		for (i=0; i<10; ++i) {
			*p++ = '0' | usercode & 1;
			usercode >>= 1;
		}
	}
	_ret ();
}

/*________________________________________________________________
 *
 *  5. : f = ACOMP(p1, ipbi, ipbo, inoff, outoff, wcell, rcell, bcnt)
 *
 *     :        
 *                     "" 
 *                     f, wcell, rcell  bcnt.
 *      :
 *     1. p1      -  .  1 .
 *                   p1 = '0' -    
 *                   p1 = '+' -     
 *                   p1 = '-' -     
 *     2. ipbi    -  .  1 .
 *                  != '0' -      
 *     3. ipbo    -  .  1 .
 *                  != '0' -      
 *     4. inoff   -   
 *     5. outoff  -   
 *      :
 *     1. f       -  .  1 .
 *                  f = '0' -   
 *                  f = '1' - 
 *     2. wcell   -  .  8 .
 *                     .
 *     3. rcell   -  .  8 .
 *                     .
 *     4. bcnt    -  .  4 .
 *                        HEX.
 */

CLIPPER ACOMP ()
{
	static char retbuf [4];
	char mode = _parc (1) [0];
	int ipbi = _parc (2) [0] != '0';
	int ipbo = _parc (3) [0] != '0';
	int inoff = atox (_parc (4));
	int outoff = atox (_parc (5));
	char *wcell = _parc (6);
	char *rcell = _parc (7);
	char *bcnt = _parc (8);
	static int offset;
	int cmplen;

	if (! buflen)
		goto equal;
	cmplen = buflen - (inoff > outoff ? inoff : outoff);
	if (mode == '0')
		offset = -1;
	if (offset >= cmplen)
		offset = cmplen;
	if (offset < 0)
		offset = -1;
	do {
		offset += mode=='-' ? -1 : 1;
		if (offset >= cmplen)
			goto equal;
		if (offset < 0)
			goto equal;
	} while (inbuf [offset] == outbuf [offset ^ ipbi ^ ipbo]);

	btoa (wcell, outbuf [offset ^ ipbi ^ ipbo], 8);
	btoa (rcell, inbuf [offset], 8);
	xtoa (bcnt, offset, 4);
	retbuf [0] = '1';
	retbuf [1] = 0;
	_retc (retbuf);
	return;
equal:
	retbuf [0] = '0';
	retbuf [1] = 0;
	_retc (retbuf);
}

/*________________________________________________________________
 *
 *  6. : f = PAR(p1)
 *
 *     :      p1
 *                      2   p1.
 *      :
 *                       p1 -  .  n .
 *                              - '0'  '1'.
 *      :
 *                 f -  .  1 .
 *                     f = '0'  '1'    .
 */

CLIPPER PAR ()          /* f = PAR (p1) */
{
	char *p = _parc (1);
	register i, rez;
	static char retbuf [2];

	rez = 0;
	for (i=strlen(p); --i>=0; ++p)
		rez ^= *p;
	retbuf [0] = '0' | rez & 1;
	retbuf [1] = 0;
	_retc (retbuf);
}

/*________________________________________________________________
 *
 * 		 pp.
 */

atox (p)
register char *p;
{
	int ret;

	for (ret=0; *p; ++p)
		ret = ret << 4 | hexdig (*p);
	return (ret);
}

atoi (p)
register char *p;
{
	int ret;

	for (ret=0; *p; ++p)
		ret = ret * 10 + (*p - '0');
	return (ret);
}

atob (p)
register char *p;
{
	register i, ret;

	for (ret=0, i=0; i<8; ++p, ++i)
		ret |= (*p & 1) << i;
	return (ret);
}

hexdig (c)
{
	switch (c) {
	case '0': case '1': case '2': case '3': case '4':
	case '5': case '6': case '7': case '8': case '9':
		return (c - '0');
	case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
		return (c - 'a' + 10);
	case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
		return (c - 'A' + 10);
	}
	return (0);
}

btoa (p, b, n)
register char *p;
{
	while (--n >= 0) {
		*p++ = '0' | b & 1;
		b >>= 1;
	}
	*p = 0;
}

xtoa (p, b, n)
register char *p;
{
	while (--n >= 0)
		*p++ = hexdigit [b >> (n*4) & 0xf];
	*p = 0;
}

setrandom (seed)
{
	randx = seed;
}

getrandom ()
{
	randx = randx * 1103515245L + 12345;
	return (randx >> 16 & 0x7fff);
}

fillarray (buf, length, mode, ucode)
short *buf;
{
	register count;

	switch (mode) {
	default:                /* 00 -  ,  */
		return;
	case 0x22:              /* 22 -   00 */
		ucode = 0x00;
varloop:
		ucode = ucode & 0xff | ucode << 8 & 0x300;
		for (count=0; count<length; ++count) {
			buf [count] = ucode;
			ucode ^= 0x3ff;
		}
		break;
	case 0x23:              /* 23 -   55 */
		ucode = 0x55;
		goto varloop;
	case 0x24:              /* 24 -   xx */
		goto varloop;
	case 0x25:              /* 25 -   .1 */
		ucode = 1;
		for (count=0; count<length; ++count) {
			buf [count] = ucode;
			ucode = ucode << 1 & 0x3ff;
			if (! ucode)
				ucode = 1;
		}
		break;
	case 0x26:              /* 26 -   .0 */
		ucode = 1;
		for (count=0; count<length; ++count) {
			buf [count] = ucode ^ 0x3ff;
			ucode = ucode << 1 & 0x3ff;
			if (! ucode)
				ucode = 1;
		}
		break;
	case 0x27:              /* 27 -   . */
		for (count=0; count<length; ++count)
			buf [count] = count & 0xff | count << 8 & 0x300;
		break;
	case 0x28:              /* 28 -   . */
		setrandom (ucode);
		for (count=0; count<length; ++count)
			buf [count] = getrandom () & 0x3ff;
		break;
	case 0x32:              /* 32 -   00 */
		ucode = 0x00;
fixloop:
		ucode = ucode & 0xff | ucode << 8 & 0x300;
		for (count=0; count<length; ++count)
			buf [count] = ucode;
		break;
	case 0x33:              /* 33 -   FF */
		ucode = 0xff;
		goto fixloop;
	case 0x34:              /* 34 -   55 */
		ucode = 0x55;
		goto fixloop;
	case 0x35:              /* 35 -   AA */
		ucode = 0xaa;
		goto fixloop;
	case 0x36:              /* 36 -   xx */
		goto fixloop;
	}
}

dma6 (buf, len, wflag)				/*   6 dma */
char *buf;
register len;
{
	register long addr;
	register mode;

	addr = PHYSADDR ((char far *) buf);
	len = (len + 1) / 2 - 1;
	mode = (wflag ? DMAM_READ : DMAM_WRITE) | DMA_CHAN6;
	out (DMA_CLRFF, 0);			/* clear flipflop */
	out (DMA_PG6, (BYTE) (addr>>16));	/* page number */
	out (DMA_OFF6, (BYTE) (addr>>1));	/* page offset */
	out (DMA_OFF6, (BYTE) (addr>>9));	/* page offset */
	out (DMA_CNT6, (BYTE) len);		/* length in words */
	out (DMA_CNT6, (BYTE) (len>>8));	/* length in words */
	out (DMA_MODE, mode);			/* Demand Write Chan 2 */
	out (DMA_MASK, DMA_CHAN6);		/* clear channel 2 mask */
}

dma7 (buf, len, wflag)				/*   7 dma */
char *buf;
register len;
{
	register long addr;
	register mode;

	addr = PHYSADDR ((char far *) buf);
	len = (len + 1) / 2 - 1;
	mode = (wflag ? DMAM_READ : DMAM_WRITE) | DMA_CHAN7;
	out (DMA_CLRFF, 0);			/* clear flipflop */
	out (DMA_PG7, (BYTE) (addr>>16));	/* page number */
	out (DMA_OFF7, (BYTE) (addr>>1));	/* page offset */
	out (DMA_OFF7, (BYTE) (addr>>9));	/* page offset */
	out (DMA_CNT7, (BYTE) len);		/* length in words */
	out (DMA_CNT7, (BYTE) (len>>8));	/* length in words */
	out (DMA_MODE, mode);			/* Demand Read Chan 3 */
	out (DMA_MASK, DMA_CHAN7);		/* clear channel 3 mask */
}

void interrupt intrcatcher ()
{
	++intrflag;
	out (INTCTLR1, 0x20);
	out (INTCTLR2, 0x20);
}

setintr (inum)
{
	/*      */
	_disable ();
	savevect = _dos_getvect (intvecnum [inum]);
	_dos_setvect (intvecnum [inum], intrcatcher);
	if (inum < 8)
		out (INTCTLR1+1, in (INTCTLR1) & ~(1 << inum));
	else
		out (INTCTLR2+1, in (INTCTLR2) & ~(1 << (inum-8)));
	_enable ();
}

resetintr (inum)
{
	/*      */
	_disable ();
	_dos_setvect (intvecnum [inum], savevect);
	if (inum < 8)
		out (INTCTLR1+1, in (INTCTLR1) | 1 << inum);
	else
		out (INTCTLR2+1, in (INTCTLR2) | 1 << (inum-8));
	_enable ();
}

idlerun (dummy)
long dummy;
{
	int i;

	for (i=0; i<10; ++i)
		dummy = dummy * dummy + 1;
	return (dummy);
}

long computelpms ()
{
	long count;
	register t1, t2;

	t1 = in (SYSTIMER);
	t2 = in (SYSTIMER);
	while ((t1 == in (SYSTIMER)) & (t2 == in (SYSTIMER)))
		/* void */;
	t1 = in (SYSTIMER);
	t2 = in (SYSTIMER);
	for (count=0; (t1 == in (SYSTIMER)) & (t2 == in (SYSTIMER)); ++count)
		idlerun (0L);
	return (count / 55 + 1);
}