# include "svsb.h"
# include "scio.h"

/* # define DEBUG */

# define DELAY(n)       { int i=n; while (--i>=0); }

struct sccmd scgo = { 0, 0, 0, 8, 0, };

int chantab [4] = { 0x38, 0xd8, 0x58, 0x80, };

/*
 *    
 *    
 * - 
 *   ,  
 *
 *      
 */

int scio (chan, unit, opcode, addr, size, tags)
int chan;               /*  , 2  */
int unit;               /*  , 2  */
int opcode;             /* , 8  */
int addr;               /*    , 23  */
int size;               /*    , 19  */
int tags;               /*     */
{
	struct sccmd ccw;

	ccw.addr = addr;
	ccw.count = size >> 3;
	ccw.flg = tags << 7 | (size & 7) << 4;
	ccw.cmd = opcode;
	ccw.unit = chantab [chan] + unit;

	return (scwait (chan, &ccw));
}

int scwait (chan, prog)         /*     */
int chan;                       /*  , 0-3 */
int *prog;                      /*   */
{
	int csw;                /*    */
	int waitmask;           /*      */

	waitmask = SCC_IOEND (chan) | SCC_CSTATUS (chan);
# ifdef DEBUG
	printf ("scio: %w\n");
# endif
repeat:
	_flush_ ();                             /*   */
	_out_ (SC_CAW (chan) | SCA_START, prog); /*   */
wait:
	/*       */
	while (! (_in_ (SC_CTL) & waitmask))
		idle (1);
	/*    */
	csw = _in_ (SC_CSW (chan) | SCA_NOHALT);
	if (csw & 1) {                          /* - */
		_in_ (SC_CSW (chan) | SCA_NOHALT | SCA_RESET);
		goto repeat;
	}
	if ((csw & 0xf) == 0xa) {               /*   */
		_in_ (SC_CSW (chan) | SCA_NOHALT | SCA_RESET);
		goto wait;
	}
	return (csw);
}

/*
 *   
 */

screset (chan)
int chan;               /*  , 2  */
{
	register i, a;

	_out_ (SC_CTL, SCC_HRESET (chan));      /*   */
	_out_ (SC_CTL, 0);                      /*    */
	_out_ (SC_CAW (chan) | SCA_START, &scgo); /*   0 */
	DELAY (100);                            /*  */
	a = SC_LMEM (chan);                     /*   */
	for (i=0; i<8; ++i)
		_out_ (a + i, 0);               /*    */
	_in_ (SC_CSW (chan) | SCA_NOHALT | SCA_RESET);
}

/*
 *   
 */

scinit ()
{
	int chan;

	for (chan=0; chan<4; ++chan)
		screset (chan);
}
