/*      */

# define SC_CTL         0x24

/*       */

# define SCC_HRESET(n)  (1 << (43-(n))) /*  */
# define SCC_IOEND(n)   (1 << (39-(n))) /*   */
# define SCC_CSTATUS(n) (1 << (35-(n))) /*   */

/*    */

# define SC_LMEM(n)     ((n)<<3|0x80)   /*   */
# define SC_CCW(n)      SC_LMEM(n)      /*    */
# define SC_CAW(n)      (SC_LMEM(n)|4)  /*    */
# define SC_CSW(n)      (SC_LMEM(n)|6)  /*    */

/*     */

# define SCA_NOHALT     0x200           /* .  -   */
# define SCA_RESET      0x400           /*   */
# define SCA_SBLOCK     0x001           /*  - */
# define SCA_START      0x400           /*  */

# define XFER           0x8             /*   */

struct sccmd {
	int addr        :24;
	int count       :16;
	int flg         :8;
	int cmd         :8;
	int unit        :8;
};
