/*
 * Startup code for standalone system
 * Non-relocating version -- for programs which are loaded by boot
 * Relocating version for boot
 */

EXTINT  =       27h             ; 
INTINT  =       1fh             ; 
STACK   =       3e000h          ;  

sp      =       15              ;  
ap      =       12              ;   
rt      =       14              ;   

	.text

# ifdef REL
x1:     uj      entry-RELOC+1
# else
x1:     uj      start
# endif

x2:     rmod    EXTINT          ;  
	halt    2
x3:     halt    3               ;  (00)  3
x4:     rmod    INTINT          ;    1, 2
	halt    4
x5:     rmod    INTINT          ;    1, 2
	halt    5
x6:     rmod    INTINT          ;    3
	halt    6
x7:     rmod    INTINT          ;    3
	halt    7

;  (050-077)  1, 2

x8:     halt    8               ; 50
x9:     halt    9               ; 51
xa:     halt    0ah             ; 52
xb:     halt    0bh             ; 53
xc:     halt    0ch             ; 54
xd:     halt    0dh             ; 55
xe:     halt    0eh             ; 56
xf:     halt    0fh             ; 57
x10:    halt    10h             ; 60
x11:    halt    11h             ; 61
x12:    halt    12h             ; 62
x13:    halt    13h             ; 63
x14:    halt    14h             ; 64
x15:    halt    15h             ; 65
x16:    halt    16h             ; 66
x17:    halt    17h             ; 67
x18:    halt    18h             ; 70
x19:    halt    19h             ; 71
x1a:    halt    1ah             ; 72
x1b:    halt    1bh             ; 73
x1c:    halt    1ch             ; 74
x1d:    halt    1dh             ; 75
x1e:    halt    1eh             ; 76
x1f:    halt    1fh             ; 77

# ifdef REL

entry:  .globl  entry           ; move itself to address RELOC
	vtm     _edata,13
	vtm     _edata-RELOC+1,14
jloop:  ktga    -1,14
	atgk    -1,13
	vim     jloop-RELOC+1,14

	uj      start           ; jump to new place

start:
	vtm     0x3fff0,13      ;     
:       do      15
	ztx     ,13++

	vtm     STACK,sp        ;  
	mtj     14,15           ;  
	xta
	ntr     400h            ;  0
:       do      4095            ; 32 K
	atgk    1,14            ;   

	utm     1,sp            ;  
	ntr     200h            ;  

# else /* REL */

start:
	ntr     200h            ;  
	ita     rt
	atx     ret

# endif /* REL */

;   bss

	vtm     _edata,14       ;   bss
	vtm     _end,13         ;   bss
	jsm     14,13           ; 1 -  bss
	xta
	ntr     400h            ;  0
:       atgx    _end,14
	vlm     .,14

;     .

	xts     #0              ;  
	vjm     _main,rt        ; main (argc, argv, environ);

; int _rtt ();  -- return from standalone program

__rtt:  .globl  __rtt
# ifdef REL
	uj      start           ; _rtt () from boot
# else
	uj      [ret]           ; _rtt () from standalone program
# endif

	.globl  _wcopy
_wcopy:                 ; wcopy (int *a, int *b, int sz);
	atc             ;    a  b
	utm     ,sp     ; pop args
	ita     ap
	mtj     ap,sp   ;   1 
	utm     3,sp    ;  
	its     1
	xts     0,ap    ; a
	ati     1
	ita     2
	xts     1,ap    ; b
	ati     2
:       wtc     2,ap    ; sz-1
	do      -1      ; sz-1
:       xta     ,1++
	atx     ,2++
	sti
	sti     2
	sti     1
	sti     ap
	utm     -3,sp   ;  
	uj      ,rt

	.globl  _wcmp
_wcmp:                  ; wcmp (int *a, int *b, int sz);
	atc             ;  
	utm     ,sp     ; pop args
	ita     ap
	mtj     ap,sp   ;   1 
	utm     3,sp    ;  
	its     1
	xts     0,ap    ; a
	ati     1
	ita     2
	xts     1,ap    ; b
	ati     2
	ita     3
	xts     2,ap    ; sz
	ati     3
:       xta     ,1++
	aex     ,2++
:       ui      .+2
	utm     -1,3
:       vpm     .-2,3
:       stx     2,ap    ; return (0);
	sti     3
	sti     2
	sti     1
	sti     ap
	utm     -3,sp   ;  
	uj      ,rt

	.globl  _wzero
_wzero:                 ; wzero (int *p, int sz);
	atc             ;  
	utm     ,sp     ; pop args
	ita     ap
	mtj     ap,sp   ;   1 
	utm     2,sp    ;  
	its     1
	xts     0,ap    ; p
:       ati     1
	wtc     1,ap
:       do      -1      ; sz-1
	ztx     ,1++
	sti
	sti     1
	sti     ap
	utm     -2,sp   ;  
	uj      ,rt

	.globl  _clrtg
_clrtg:                 ; clrtg (int buf [131]);
	atc             ;  
	utm     ,sp     ; pop args
	ita     ap
	mtj     ap,sp   ;   1 
	utm     1,sp    ;  
	its     2
	its     1
	xts     0,ap    ; &buf
	ati     1       ; &buf
	ati     2       ; &buf
:       ntr     400h    ;  0
	do      130
:       xta     ,1++
	atgx    ,2++
	sti
	sti     1
	sti     2
	sti     ap
	utm     -1,sp   ;  
	uj      ,rt

	.globl  _crc
_crc:                   ; int crc (int buf [128]);
	atc             ;  . 
	utm     -1,sp   ; pop args
	ita     rt
	wtc     1,sp
	vtm     ,rt
	its
:       do      127
	ark     1,rt
	wtc     ,sp
	uj

	.globl  _inverword
_inverword:
	atc
	utm     -1,sp   ; pop args
	xta     1,sp
	asn     1024+32
	yta     10h

	atx     ,sp
	aln     1024+16
	aax     #0xffff0000ffff0000
	stx     ,sp
	aax     #0xffff0000ffff0000
	asn     1024+16
	aex     1,sp

	atx     ,sp
	aln     1024+8
	aax     #0xff00ff00ff00ff00
	stx     ,sp
	aax     #0xff00ff00ff00ff00
	asn     1024+8
	aex     1,sp

	uj      ,rt

	.globl  _inverhword
_inverhword:
	atc
	utm     -1,sp   ; pop args
	xta     1,sp
	asn     1024+32
	yta     10h

	atx     ,sp
	aln     1024+16
	aax     #0xffff0000ffff0000
	stx     ,sp
	aax     #0xffff0000ffff0000
	asn     1024+16
	aex     1,sp

	uj      ,rt

	.data
ret:    .word
