/*
 *   - - PC AT,  
 *
 *     .
 *  -   ,
 *         .
 *  PC    ,
 *    ,  -
 *     .
 *          
 *    -  .
 *      .
 */

# include "svsb.h"
# include "ucio.h"

# define DFLTUNIT       2

# define INCREMENT      0x155

# define in             _in_
# define out            _out_

# define ODD(c)         (_nbits_ (c) & 1)

int oreg, ireg;
int rerr, serr, cerr;

main ()
{
	int u;

	printf (MSG ("\nUCTEST %s    %s\n", "\n  %s    %s\n"),
		BOOTVERSION, MSG (LCOPYRIGHT, RCOPYRIGHT));
	putchar ('\n');
	u = getint (MSG ("Enter channel number: (0-3) [%d] ",
		"   (0-3) [%d] "), DFLTUNIT);
	printf (MSG ("\nTesting uc%d.\nPress ^^ to abort\n",
		"   %d\n ,  ^^\n"), u);
	uctest (u);
}

getint (s, dflt)
char *s;
{
	int i;
	char line [80];

	do {
		printf (s, dflt);
		gets (line);
		if (! line [0])
			return (dflt);
		i = atoi (line);
	} while (i<0 || i>3);
	return (i);
}

account (n)
long n;
{
	static long t0, tlast;
	long tnew;

	if (! n) {
		tlast = t0 = time (0L);
		return;
	}
	tnew = time (0L);
	printf ("\n ");
	prtime (tnew - t0);
	printf ("  %ld ,   %d /\n",
		n, 2*1024 / (tnew - tlast));
	printf ("  %d,  %d,  %d\n",
		rerr, serr, cerr);
	tlast = time (0L);
}

prtime (t)
register long t;
{
	register h, m, s;

	h = t / 3600;
	m = (t -= (long) h * 3600) / 60;
	s = t - m * 60;
	if (h)
		printf ("%d:%d:%d", h, m, s);
	else
		printf ("%d:%d", m, s);
}

uctest (u)
{
	int c, i, w;
	long n;

	oreg = 0;
	UC_OUTNACK (u, oreg);

	i = 0;
	w = 0;
	n = 0;
	account (0L);
	for (;;) {
		idle (1);
		c = recv (u, w);
		if (c != w) {
			printf ("(%xh # %xh)", w, c);
			++cerr;
		}
		send (u, c);
		w = (c + INCREMENT) & UC_DATA;
		if (++i >= 0x400) {
			if (++n % 1024 == 0)
				account (n);
			i = 0;
			putchar ('.');
		}
	}
}

recv (u, w)
{
	int c;

	for (;;) {
		ireg = in (UCREG (u));
		if (! (ireg & UC_STROBE)) {     /* wait for strobe */
			idle (1);
			continue;
		}
		UC_OUTCLR (u, UC_RDY, oreg);    /* clear 'ready' */

		c = ireg & UC_PDATA;            /* get data & parity */
		if (! ODD (c)) {
			UC_OUTNACK (u, oreg);   /* bad parity */
			putchar ('R');
			if (w >= 0)
				printf ("<%x # %x>", w, c);
			idle (1);
			++rerr;
			continue;               /* wait for retry */
		}
		UC_OUTACK (u, oreg);            /* receive ok */
		return (c & UC_DATA);
	}
}

send (u, d)
{
	d &= UC_DATA;
	if (! ODD (d))
		d |= UC_PARITY;
	UC_OUTDATA (u, d, oreg);

	for (;;) {
		ireg = in (UCREG (u));
		if (! (ireg & UC_RDY)) {        /* wait for 'ready' */
			idle (1);
			continue;
		}
		UC_OUTCLR (u, UC_STROBE, oreg); /* clear strobe */
		if (! (ireg & UC_ACK)) {
			putchar ('S');          /* bad parity */
			UC_OUTDATA (u, d, oreg); /* retry */
			idle (1);
			++serr;
			continue;
		}
		return;                         /* send ok */
	}
}
