# ifdef MSDOS
# include <stdlib.h>
# endif
# include "scr.h"
# include "menu.h"

/* menu handler */

extern void load_sas(), load_batch(), save_batch(), change_batch(), init_batch();
extern void run_sas(), figwam(), doquit(), rrun(), zero(), stop(), State_B();
extern void run_pult (), load_part (), store_part (),
# ifdef MSDOS
run_dos (),
# else
run_unix (),
# endif
get_batch_wg (), store_tst (), store_any (), load_any ();
extern void reset_U_Chan (), Debug_Toggle ();
extern inited_batch, loaded_sas, loaded_batch, saved_batch, debug_mode;
static tag();

static struct submenu sas [] = {
	{       "㧨 ",        'l',    load_sas,       },
	{       "㧨 ",    'f',    load_batch,     },
	{       "࠭ ",    's',    save_batch,     },
	{       "㧨   ",'g',  get_batch_wg,   },
	{       "롮 ⨯ ",   'i',    init_batch,     },
	{       " ",     'b',    change_batch,   },
	{       "믮 ",        'r',    run_sas,        },
	{       "ᬮ ॣ஢",   'v',    State_B,        },
	{       "騩  (0)",      'u',    zero,           },
	{       " ० ()", 'o',    stop,           },
	{       "  ()", 'a',    rrun,           },
	/*{       "",              'e',    0,              },*/
	{       0,                      0,      0,              },
};

static struct submenu term [] = {
	{	" VDT",	      '7',    figwam,	       },
	/*{       "",              'e',    0,              },*/
	{       0,                      0,      0,              },
};

static struct submenu utils [] = {
	{	"㧨 TST-䠩",	't',	store_tst,	},
	{	"㧨 䠩",	'a',	store_any,	},
	{	" 䠩", 	'c',	load_any,	},
	{	"⥭  ࠧ",	'r',	load_part,	},
	{	"  ࠧ",	'w',	store_part,	},
	{	" 㭨. ",	'u',	reset_U_Chan,	},
	/*{       "",              'e',    0,              },*/
	{       0,                      0,      0,              },
};

static struct submenu debug [] = {
# ifdef MSDOS
	{       "ணࠬ ",      'p',    run_pult,       },
# endif
	{	"⫠ ०",	'm',	Debug_Toggle,	},
	/*{       "",              'e',    0,              },*/
	{       0,                       0,     0,              },
};

static struct submenu quit [] = {
	{       " ᥠ",         'n',    doquit,         },
# ifdef MSDOS
	{       "믮  DOS",'d',    run_dos,        },
# else
	{       "믮  UNIX",'d',    run_unix,        },
# endif
	/*{       "",              'e',    0,              },*/
	{       0,                       0,     0,              },
};

struct menu menu [] = {
	{       "ࢨ",       's',            sas,    0,0,0,0,6},
	{       "⨫",      'u',            utils,  },
	{       "ନ",     't',            term,   },
	{       "⫠稪",     'd',            debug,  },
	{       "室",        'q',            quit,   },
	{       0,              0,              0,      },
};

int nmenu = 0;

runmenu (mkey)
{
	register struct menu *m;
	register struct submenu *sm;
	int      mnkey;

	nmenu = 0;

	if ( mkey == 0)
		mnkey = menu->key;
	else
		mnkey = abs(mkey);

	for (m=menu; m->name; ++m) {
		if (m->key == mnkey)
			nmenu = m-menu;
		for (sm=m->submenu; sm->name; ++sm) {
			sm->active = sm->exec != 0;
			sm->tag = tag (m->key, sm->key);
		}
		if (mnkey != m->key) {
			m->nsm = -1;
			for (;;) {
				if (! m->submenu[++m->nsm].name)
					m->nsm = 0;
				if (m->submenu[m->nsm].active)
					break;
			}
		}
	}
	if (! getmenu (mkey))
		return 0;
	m = &menu[nmenu];
	sm = &m->submenu[m->nsm];
	if (sm->exec) {
		(*sm->exec) (m->key, sm->key);
		return m->key;
	}
	else
		return -m->key;
}

static tag (k, sk)
{
	switch (k) {
	case 's':
		switch (sk) {
		case 'i':
			return (inited_batch);
		case 'l':
			return (loaded_sas);
		case 'f':
			return (loaded_batch);
		case 's':
			return (saved_batch);
		}
		break;
	case 'd':
		switch (sk) {
		case 'm':
			return (debug_mode);
		}
		break;
	}
	return (0);
}

