/*
 *        a.out:
 *
 *        9        407, 410
 *                                const    )
 *                                text     )
 *                                data     )  ,  8
 *                                bss      )
 *                                abss     )
 *                                  )
 *                               
 *                               
 *
 *                     0
 *      const:                  72
 *      text:                   72 + constsize
 *      data:                   72 + constsize + textsize
 *       const:        72 + constsize + textsize + datasize
 *       text:         72 + 2*constsize + textsize + datasize
 *       data:         72 + 2*constsize + 2*textsize + datasize
 *       :       72 + 2*constsize + 2*textsize + 2*datasize
 *
 */

struct exec {           /*   a.out */
	int     a_magic;
	long    a_const;
	long    a_text;
	long    a_data;
	long    a_bss;
	long    a_abss;
	long    a_syms;
	long    a_entry;
	short   a_flag;
};

			/*    */
struct nlist {
	short           n_len;          /*     */
	short           n_type;         /*  */
	long            n_value;        /*  */
	char *          n_name;         /*    */
};

			/*  */
# define RELFLG 1       /*   */
# define TCDFLG 2       /*       */

# define HDRSZ  72      /*     */

			/*   */
# define FMAGIC 0407
# define NMAGIC 0410
# define AMAGIC 0411

			/*   */
# define N_EXT  040
# define N_TYPE 037     /*  */
# define N_FN   037
# define N_UNDF 00
# define N_ABS  01
# define N_CONST 02
# define N_TEXT 03
# define N_DATA 04
# define N_BSS  05
# define N_ABSS 06
# define N_STRNG 07     /*  as */
# define N_COMM 010
# define N_ACOMM 011

			/*   */
# define RABS   0
# define RCONST 010
# define RTEXT  020
# define RDATA  030
# define RBSS   040
# define RABSS  050
# define RSTRNG 060     /*  as */
# define REXT   070     /*     */

# define RSHIFT 04
# define RTRUNC 05
# define RLONG  06
# define RSHORT 07      /*     */

# define RGETIX(h) ((h)>>6)
# define RPUTIX(h) ((long)(h)<<6)

/* ,     ,   */

# define N_TXTOFF(x)    HDRSZ
# define N_SYMOFF(x)    (N_TXTOFF(x) + (x).a_const + (x).a_text + (x).a_data)
# define N_STROFF(x)    (N_SYMOFF(x) + (x).a_syms)

# define BADMAG(x)      ((x).a_magic != FMAGIC && (x).a_magic != NMAGIC)
# define N_BADMAG       BADMAG
# define FORMAT         "%07lx" /*     */
# define N_FORMAT       FORMAT
