/*
 *  -.
 *
 * : as [-uxXd] file.s [-o outfile]
 *
 * -u   -     
 * -x   -       
 * -X   -      ,   'L'
 * -d   -  
 * -b   -   
 *
 * :  . .
 */

# include <stdio.h>

# ifdef CROSS
#    include "../h/a.out.h"
# else
#    include <a.out.h>
# endif

# define W 8                    /*     */

/*   */

# define LEOF   1
# define LEOL   2
# define LNAME  3
# define LCMD   4
# define LACMD  5
# define LNUM   6
# define LLCMD  7
# define LSCMD  8
# define LLSHIFT 9
# define LRSHIFT 10
# define LINCR  11
# define LDECR  12

/*   */

# define SCONST 0
# define STEXT  1
# define SDATA  2
# define SSTRNG 3
# define SBSS   4
# define SABSS  5
# define SEXT   6
# define SABS   7               /*    getexpr */

/*   */

# define ABSS   0
# define ACOMM  1
# define ASCII  2
# define BSS    3
# define COMM   4
# define DATA   5
# define GLOBL  6
# define HALF   7
# define STRNG  8
# define TEXT   9
# define EQU    10
# define WORD   11

/*   */

# define TLONG  01                      /*   */
# define TALIGN 02                      /*     */
# define TLIT   04                      /*     */
# define TINT   010                     /*     */
# define TCOMP  020                     /*      */

/*   */
/* -    ! */

# define HASHSZ 2048                    /*     */
# define HCONSZ 256                     /*     */
# define HCMDSZ 1024                    /*     */

# define STSIZE (HASHSZ*9/10)           /*    */
# define CSIZE  (HCONSZ*9/10)           /*    */
# define SPACESZ (STSIZE*8)             /*     */

# define SEGMTYPE(s)    segmtype[s]     /*      */
# define TYPESEGM(s)    typesegm[s]     /*      */
# define TYPEREL(s)     typerel((int) s) /*      */
# define SEGMREL(s)     segmrel[s]      /*      */

# define EMPCOM         0x3a00000L      /*   -  */
# define UTCCOM         0x3a00000L      /*  <> */
# define WTCCOM         0x3b00000L      /*  [] */

/*     */

# define MAKECOMP(c)    ((c) & 0x2000000L ? (c)|0x4800000L : (c)|0x6000000L)

/*   -  32-  == 011706736335L */
/*     16-  = 067433 */

# define SUPERHASH(key,mask) (((short)(key) * (short)067433) & (short)(mask))

# define ISHEX(c)       (ctype[(c)&0377] & 1)
# define ISOCTAL(c)     (ctype[(c)&0377] & 2)
# define ISDIGIT(c)     (ctype[(c)&0377] & 4)
# define ISLETTER(c)    (ctype[(c)&0377] & 8)

/*    hashtab  ,    
/* newindex       x  X */

# define newindex hashtab

short ctype [256] = {
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,7,7,7,7,7,7,7,7,5,5,0,0,0,0,0,0,
	0,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,0,0,0,8,
	0,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,
};

short segmtype [] = {   /*       */
	N_CONST,        /* SCONST */
	N_TEXT,         /* STEXT */
	N_DATA,         /* SDATA */
	N_STRNG,        /* SSTRNG */
	N_BSS,          /* SBSS */
	N_ABSS,         /* SABSS */
	N_UNDF,         /* SEXT */
	N_ABS,          /* SABS */
};

short segmrel [] = {    /*       */
	RCONST,         /* SCONST */
	RTEXT,          /* STEXT */
	RDATA,          /* SDATA */
	RSTRNG,         /* SSTRNG */
	RBSS,           /* SBSS */
	RABSS,          /* SABSS */
	REXT,           /* SEXT */
	RABS,           /* SABS */
};

short typesegm [] = {   /*       */
	SEXT,           /* N_UNDF */
	SABS,           /* N_ABS */
	SCONST,         /* N_CONST */
	STEXT,          /* N_TEXT */
	SDATA,          /* N_DATA */
	SBSS,           /* N_BSS */
	SABSS,          /* N_ABSS */
	SSTRNG,         /* N_STRNG */
};

/*
 *     
 *     :
 *
 *      , , , , , , 
 *
 *     
 */

struct table {
	long val;
	char *name;
	short type;
} table [] = {
	0x0000000L,     "",           TLONG|TCOMP,
	0x0000000L,     "",           TLONG|TCOMP,
	0x0000000L,     "atx",          TLONG|TCOMP,
	0x0100000L,     "",           TLONG|TCOMP,
	0x0100000L,     "",          TLONG|TCOMP,
	0x0100000L,     "stx",          TLONG|TCOMP,
	0x0200000L,     "",           TLONG|TLIT|TCOMP,
	0x0200000L,     "",          TLONG|TLIT|TCOMP,
	0x0200000L,     "xtna",         TLONG|TLIT|TCOMP,
	0x0200000L,     "xtra",         TLONG|TLIT|TCOMP,
	0x0300000L,     "",           TLONG|TLIT|TCOMP,
	0x0300000L,     "",          TLONG|TLIT|TCOMP,
	0x0300000L,     "xts",          TLONG|TLIT|TCOMP,
	0x0400000L,     "",           TLONG|TLIT|TINT|TCOMP,
	0x0400000L,     "",           TLONG|TLIT|TINT|TCOMP,
	0x0400000L,     "aadx",         TLONG|TLIT|TINT|TCOMP,
	0x0400000L,     "apx",          TLONG|TLIT|TINT|TCOMP,
	0x0500000L,     "",           TLONG|TLIT|TINT|TCOMP,
	0x0500000L,     "",           TLONG|TLIT|TINT|TCOMP,
	0x0500000L,     "asux",         TLONG|TLIT|TINT|TCOMP,
	0x0500000L,     "asx",          TLONG|TLIT|TINT|TCOMP,
	0x0600000L,     "",         TLONG|TLIT|TINT|TCOMP,
	0x0600000L,     "",           TLONG|TLIT|TINT|TCOMP,
	0x0600000L,     "xsa",          TLONG|TLIT|TINT|TCOMP,
	0x0600000L,     "xsua",         TLONG|TLIT|TINT|TCOMP,
	0x0700000L,     "",         TLONG|TLIT|TCOMP,
	0x0700000L,     "",           TLONG|TLIT|TCOMP,
	0x0700000L,     "amsx",         TLONG|TLIT|TCOMP,
	0x0800000L,     "",           TLONG|TLIT|TCOMP,
	0x0800000L,     "xta",          TLONG|TLIT|TCOMP,
	0x0900000L,     "",            TLONG|TLIT|TCOMP,
	0x0900000L,     "",           TLONG|TLIT|TCOMP,
	0x0900000L,     "aax",          TLONG|TLIT|TCOMP,
	0x0a00000L,     "",          TLONG|TLIT|TCOMP,
	0x0a00000L,     "",           TLONG|TLIT|TCOMP,
	0x0a00000L,     "aex",          TLONG|TLIT|TCOMP,
	0x0b00000L,     "",          TLONG|TLIT|TCOMP,
	0x0b00000L,     "",           TLONG|TLIT|TCOMP,
	0x0b00000L,     "arx",          TLONG|TLIT|TCOMP,
	0x0c00000L,     "",           TLONG|TLIT|TINT|TCOMP,
	0x0c00000L,     "avx",          TLONG|TLIT|TINT|TCOMP,
	0x0d00000L,     "",          TLONG|TLIT|TCOMP,
	0x0d00000L,     "",           TLONG|TLIT|TCOMP,
	0x0d00000L,     "aox",          TLONG|TLIT|TCOMP,
	0x0e00000L,     "",           TLONG|TCOMP,
	0x0e00000L,     "",          TLONG|TCOMP,
	0x0e00000L,     "adx",          TLONG|TCOMP,
	0x0f00000L,     "",           TLONG|TLIT|TINT|TCOMP,
	0x0f00000L,     "",          TLONG|TLIT|TINT|TCOMP,
	0x0f00000L,     "amux",         TLONG|TLIT|TINT|TCOMP,
	0x0f00000L,     "amx",          TLONG|TLIT|TINT|TCOMP,
	0x1000000L,     "",          TLONG|TLIT|TCOMP,
	0x1000000L,     "",           TLONG|TLIT|TCOMP,
	0x1000000L,     "apkx",         TLONG|TLIT|TCOMP,
	0x1100000L,     "",           TLONG|TLIT|TCOMP,
	0x1100000L,     "",          TLONG|TLIT|TCOMP,
	0x1100000L,     "aux",          TLONG|TLIT|TCOMP,
	0x1200000L,     "",          TLONG|TLIT|TCOMP,
	0x1200000L,     "acx",          TLONG|TLIT|TCOMP,
	0x1300000L,     "",           TLONG|TLIT|TCOMP,
	0x1300000L,     "",          TLONG|TLIT|TCOMP,
	0x1300000L,     "anx",          TLONG|TLIT|TCOMP,
	0x1400000L,     "",         TLONG|TCOMP,
	0x1400000L,     "",           TLONG|TCOMP,
	0x1400000L,     "eax",          TLONG|TCOMP,
	0x1400000L,     "epx",          TLONG|TCOMP,
	0x1500000L,     "",           TLONG|TCOMP,
	0x1500000L,     "",         TLONG|TCOMP,
	0x1500000L,     "esx",          TLONG|TCOMP,
	0x1600000L,     "",         TLONG|TCOMP,
	0x1600000L,     "",           TLONG|TCOMP,
	0x1600000L,     "asrx",         TLONG|TCOMP,
	0x1700000L,     "",           TLONG,
	0x1700000L,     "",         TLONG,
	0x1700000L,     "xtr",          TLONG,
	0x1800000L,     "",           TLONG,
	0x1800000L,     "uj",           TLONG,
	0x1800000L,     "xj",           TLONG,
	0x1900000L,     "",           TLONG|TALIGN,
	0x1900000L,     "vjm",          TLONG|TALIGN,
	0x1a00000L,     "",           TLONG,
	0x1a00000L,     "",        TLONG,
	0x1a00000L,     "vgm",          TLONG,
	0x1b00000L,     "",           TLONG,
	0x1b00000L,     "",         TLONG,
	0x1b00000L,     "vlm",          TLONG,
	0x1e00000L,     "",           TLONG|TCOMP,
	0x1e00000L,     "",         TLONG|TCOMP,
	0x1e00000L,     "alx",          TLONG|TCOMP,
	0x1e00000L,     "aslx",         TLONG|TCOMP,
	0x2000000L,     "",           TLONG,
	0x2000000L,     "",         TLONG,
	0x2000000L,     "vzm",          TLONG,
	0x2100000L,     "",           TLONG,
	0x2100000L,     "",         TLONG,
	0x2100000L,     "vim",          TLONG,
	0x2200000L,     "",          TLONG,
	0x2200000L,     "",         TLONG,
	0x2200000L,     "vpzm",         TLONG,
	0x2300000L,     "",          TLONG,
	0x2300000L,     "",         TLONG,
	0x2300000L,     "vnm",          TLONG,
	0x2400000L,     "",          TLONG,
	0x2400000L,     "",         TLONG,
	0x2400000L,     "vnzm",         TLONG,
	0x2500000L,     "",           TLONG,
	0x2500000L,     "",         TLONG,
	0x2500000L,     "vpm",          TLONG,
	0x2800000L,     "",          TLONG,
	0x2800000L,     "uz",           TLONG,
	0x2800000L,     "xz",           TLONG,
	0x2900000L,     "",          TLONG,
	0x2900000L,     "",           TLONG,
	0x2900000L,     "ui",           TLONG,
	0x2900000L,     "xi",           TLONG,
	0x2a00000L,     "",          TLONG,
	0x2a00000L,     "",          TLONG,
	0x2a00000L,     "upz",          TLONG,
	0x2a00000L,     "xpz",          TLONG,
	0x2b00000L,     "",          TLONG,
	0x2b00000L,     "",          TLONG,
	0x2b00000L,     "un",           TLONG,
	0x2b00000L,     "xn1",          TLONG,
	0x2c00000L,     "",          TLONG,
	0x2c00000L,     "",          TLONG,
	0x2c00000L,     "unz",          TLONG,
	0x2c00000L,     "xnz",          TLONG,
	0x2d00000L,     "",          TLONG,
	0x2d00000L,     "",          TLONG,
	0x2d00000L,     "up",           TLONG,
	0x2d00000L,     "xp1",          TLONG,
	0x2e00000L,     "",          TLONG,
	0x2e00000L,     "",           TLONG,
	0x2e00000L,     "uiv",          TLONG,
	0x2e00000L,     "xv1",          TLONG,
	0x2f00000L,     "",          TLONG,
	0x2f00000L,     "",          TLONG,
	0x2f00000L,     "uzv",          TLONG,
	0x2f00000L,     "xvz",          TLONG,
	0x3000000L,     "",           TLONG|TCOMP,
	0x3000000L,     "",          TLONG|TCOMP,
	0x3000000L,     "xtga",         TLONG|TCOMP,
	0x3000000L,     "xtwa",         TLONG|TCOMP,
	0x3100000L,     "",          TLONG|TCOMP,
	0x3100000L,     "",           TLONG|TCOMP,
	0x3100000L,     "xtqa",         TLONG|TCOMP,
	0x3100000L,     "xtsa",         TLONG|TCOMP,
	0x3200000L,     "",           TLONG,
	0x3200000L,     "",          TLONG,
	0x3200000L,     "xtha",         TLONG,
	0x3300000L,     "",          TLONG,
	0x3300000L,     "",           TLONG,
	0x3300000L,     "xtta",         TLONG,
	0x3400000L,     "",           TLONG|TCOMP,
	0x3400000L,     "",          TLONG|TCOMP,
	0x3400000L,     "ztx",          TLONG|TCOMP,
	0x3500000L,     "",           TLONG,
	0x3500000L,     "",          TLONG,
	0x3500000L,     "atcx",         TLONG,
	0x3600000L,     "",          TLONG,
	0x3600000L,     "",           TLONG,
	0x3600000L,     "ath",          TLONG,
	0x3700000L,     "",          TLONG|TCOMP,
	0x3700000L,     "",           TLONG|TCOMP,
	0x3700000L,     "atgx",         TLONG|TCOMP,
	0x3700000L,     "atwx",         TLONG|TCOMP,
	0x3800000L,     "",          TLONG,
	0x3800000L,     "",           TLONG,
	0x3800000L,     "pctm",         TLONG,
	0x3800000L,     "vtdm",         TLONG,
	0x3900000L,     "",           TLONG,
	0x3900000L,     "",          TLONG,
	0x3900000L,     "atc",          TLONG,
	0x3a00000L,     "",          TLONG,
	0x3a00000L,     "utcs",         TLONG,
	0x3a00000L,     "xtpc",         TLONG,
	0x3b00000L,     "",           TLONG,
	0x3b00000L,     "",           TLONG,
	0x3b00000L,     "wtc",          TLONG,
	0x3b00000L,     "xtc",          TLONG,
	0x3c00000L,     "",           TLONG,
	0x3c00000L,     "",          TLONG,
	0x3c00000L,     "vtm",          TLONG,
	0x3d00000L,     "",           TLONG,
	0x3d00000L,     "",         TLONG,
	0x3d00000L,     "utm",          TLONG,
	0x3d00000L,     "xtm",          TLONG,
	0x3e00000L,     "",         TLONG,
	0x3e00000L,     "",           TLONG,
	0x3e00000L,     "do",           TLONG,
	0x3f00000L,     "",           TALIGN,
	0x3f00000L,     "ex",           TALIGN,
	0x3f01000L,     "",           TALIGN,
	0x3f01000L,     "",          TALIGN,
	0x3f01000L,     "pop",          TALIGN,
	0x3f02000L,     "",          0,
	0x3f02000L,     "",           0,
	0x3f02000L,     "rmod",         0,
	0x3f03000L,     "",          TALIGN,
	0x3f03000L,     "ij",           TALIGN,
	0x3f06000L,     "",           0,
	0x3f06000L,     "",          0,
	0x3f06000L,     "wmod",         0,
	0x3f07000L,     "",          TALIGN,
	0x3f07000L,     "",         TALIGN,
	0x3f07000L,     "halt",         TALIGN,
	0x3f11000L,     "",          0,
	0x3f11000L,     "",           0,
	0x3f11000L,     "yma",          0,
	0x3f14000L,     "",          0,
	0x3f14000L,     "",           0,
	0x3f14000L,     "ecn",          0,
	0x3f16000L,     "",          0,
	0x3f16000L,     "",           0,
	0x3f16000L,     "asn",          0,
	0x3f18000L,     "",          0,
	0x3f18000L,     "rta",          0,
	0x3f19000L,     "",           0,
	0x3f19000L,     "",           0,
	0x3f19000L,     "yta",          0,
	0x3f1a000L,     "",           0,
	0x3f1a000L,     "",         0,
	0x3f1a000L,     "een",          0,
	0x3f1b000L,     "",          0,
	0x3f1b000L,     "",           0,
	0x3f1b000L,     "set",          0,
	0x3f1c000L,     "",           0,
	0x3f1c000L,     "",          0,
	0x3f1c000L,     "ean",          0,
	0x3f1d000L,     "",          0,
	0x3f1d000L,     "",           0,
	0x3f1d000L,     "esn",          0,
	0x3f1e000L,     "",           0,
	0x3f1e000L,     "",          0,
	0x3f1e000L,     "aln",          0,
	0x3f1f000L,     "",           0,
	0x3f1f000L,     "",          0,
	0x3f1f000L,     "ntr",          0,
	0x3f20000L,     "",           0,
	0x3f20000L,     "ati",          0,
	0x3f21000L,     "",          0,
	0x3f21000L,     "",           0,
	0x3f21000L,     "sti",          0,
	0x3f22000L,     "",           0,
	0x3f22000L,     "ita",          0,
	0x3f23000L,     "",          0,
	0x3f23000L,     "",           0,
	0x3f23000L,     "iita",         0,
	0x3f24000L,     "",           0,
	0x3f24000L,     "",          0,
	0x3f24000L,     "mtj",          0,
	0x3f25000L,     "",           0,
	0x3f25000L,     "",          0,
	0x3f25000L,     "jam",          0,
	0x3f26000L,     "",        0,
	0x3f26000L,     "",           0,
	0x3f26000L,     "msj",          0,
	0x3f27000L,     "",          0,
	0x3f27000L,     "",           0,
	0x3f27000L,     "jsm",          0,
	0x3f28000L,     "",           0,
	0x3f28000L,     "",           0,
	0x3f28000L,     "ato",          0,
	0x3f29000L,     "",           0,
	0x3f29000L,     "",          0,
	0x3f29000L,     "sto",          0,
	0x3f2a000L,     "",           0,
	0x3f2a000L,     "",           0,
	0x3f2a000L,     "ota",          0,
	0x3f2c000L,     "",           0,
	0x3f2c000L,     "",          0,
	0x3f2c000L,     "mto",          0,
	0x3f34000L,     "",           0,
	0x3f34000L,     "",         0,
	0x3f34000L,     "ent",          0,
	0x3f35000L,     "",         0,
	0x3f35000L,     "",           0,
	0x3f35000L,     "int",          0,
	0x3f36000L,     "",           0,
	0x3f36000L,     "",         0,
	0x3f36000L,     "asy",          0,
	0x3f38000L,     "",           0,
	0x3f38000L,     "",         0,
	0x3f38000L,     "atia",         0,
	0x3f3c000L,     "",          0,
	0x3f3c000L,     "",           0,
	0x3f3c000L,     "aca",          0,
	0x3f3e000L,     "",           0,
	0x3f3e000L,     "",         0,
	0x3f3e000L,     "aly",          0,
	0x3f3f000L,     "",          0,
	0x3f3f000L,     "",           0,
	0x3f3f000L,     "tst",          0,
	0x3f51000L,     "",         0,
	0x3f51000L,     "",          0,
	0x3f51000L,     "yms",          0,
	0x3f54000L,     "",         0,
	0x3f54000L,     "",          0,
	0x3f54000L,     "ecns",         0,
	0x3f56000L,     "",          0,
	0x3f56000L,     "",         0,
	0x3f56000L,     "asns",         0,
	0x3f58000L,     "",         0,
	0x3f58000L,     "rts",          0,
	0x3f59000L,     "",          0,
	0x3f59000L,     "",          0,
	0x3f59000L,     "yts",          0,
	0x3f5a000L,     "",          0,
	0x3f5a000L,     "",        0,
	0x3f5a000L,     "eens",         0,
	0x3f5c000L,     "",          0,
	0x3f5c000L,     "",         0,
	0x3f5c000L,     "eans",         0,
	0x3f5d000L,     "",         0,
	0x3f5d000L,     "",          0,
	0x3f5d000L,     "esns",         0,
	0x3f5e000L,     "",          0,
	0x3f5e000L,     "",         0,
	0x3f5e000L,     "alns",         0,
	0x3f5f000L,     "",          0,
	0x3f5f000L,     "",         0,
	0x3f5f000L,     "ntrs",         0,
	0x3f62000L,     "",          0,
	0x3f62000L,     "its",          0,
	0x3f63000L,     "",         0,
	0x3f63000L,     "",          0,
	0x3f63000L,     "iits",         0,
	0x3f6a000L,     "",          0,
	0x3f6a000L,     "",          0,
	0x3f6a000L,     "ots",          0,
	0x3f74000L,     "",          0,
	0x3f74000L,     "",        0,
	0x3f74000L,     "ents",         0,
	0x3f75000L,     "",        0,
	0x3f75000L,     "",          0,
	0x3f75000L,     "ints",         0,
	0x3f76000L,     "",          0,
	0x3f76000L,     "",        0,
	0x3f76000L,     "asys",         0,
	0x3f78000L,     "",          0,
	0x3f78000L,     "",        0,
	0x3f78000L,     "atis",         0,
	0x3f7c000L,     "",         0,
	0x3f7c000L,     "",          0,
	0x3f7c000L,     "acs",          0,
	0x3f7e000L,     "",          0,
	0x3f7e000L,     "",        0,
	0x3f7e000L,     "alys",         0,
	0x3f7f000L,     "",         0,
	0x3f7f000L,     "",          0,
	0x3f7f000L,     "tsts",         0,
	0x4000000L,     "",          TLONG,
	0x4000000L,     "xtal",         TLONG,
	0x4100000L,     "",          TLONG,
	0x4100000L,     "",         TLONG,
	0x4100000L,     "xtsl",         TLONG,
	0x4200000L,     "",          TLONG,
	0x4200000L,     "",         TLONG,
	0x4200000L,     "utra",         TLONG,
	0x4200000L,     "xtnal",        TLONG,
	0x4300000L,     "",          TLONG,
	0x4300000L,     "",         TLONG,
	0x4300000L,     "uts",          TLONG,
	0x4300000L,     "xtsu",         TLONG,
	0x4400000L,     "",          TLONG,
	0x4400000L,     "",          TLONG,
	0x4400000L,     "aadu",         TLONG,
	0x4500000L,     "",          TLONG,
	0x4500000L,     "",          TLONG,
	0x4500000L,     "asuu",         TLONG,
	0x4600000L,     "",        TLONG,
	0x4600000L,     "",          TLONG,
	0x4600000L,     "usua",         TLONG,
	0x4700000L,     "",        TLONG,
	0x4700000L,     "",          TLONG,
	0x4700000L,     "amu",          TLONG,
	0x4800000L,     "",          TLONG,
	0x4800000L,     "uta",          TLONG,
	0x4800000L,     "xtau",         TLONG,
	0x4900000L,     "",           TLONG,
	0x4900000L,     "",          TLONG,
	0x4900000L,     "aau",          TLONG,
	0x4a00000L,     "",         TLONG,
	0x4a00000L,     "",          TLONG,
	0x4a00000L,     "aeu",          TLONG,
	0x4b00000L,     "",         TLONG,
	0x4b00000L,     "",          TLONG,
	0x4b00000L,     "aru",          TLONG,
	0x4c00000L,     "",          TLONG,
	0x4c00000L,     "avu",          TLONG,
	0x4d00000L,     "",         TLONG,
	0x4d00000L,     "",          TLONG,
	0x4d00000L,     "aou",          TLONG,
	0x4f00000L,     "",          TLONG,
	0x4f00000L,     "",         TLONG,
	0x4f00000L,     "amuu",         TLONG,
	0x5000000L,     "",          TLONG,
	0x5000000L,     "",         TLONG,
	0x5000000L,     "apu",          TLONG,
	0x5100000L,     "",          TLONG,
	0x5100000L,     "",         TLONG,
	0x5100000L,     "auu",          TLONG,
	0x5200000L,     "",          TLONG,
	0x5200000L,     "",         TLONG,
	0x5200000L,     "acu",          TLONG,
	0x5300000L,     "",          TLONG,
	0x5300000L,     "",         TLONG,
	0x5300000L,     "anu",          TLONG,
	0x5400000L,     "",          TLONG,
	0x5400000L,     "",          TLONG,
	0x5500000L,     "",          TLONG,
	0x5500000L,     "",          TLONG,
	0x5600000L,     "",        TLONG,
	0x5600000L,     "",          TLONG,
	0x5700000L,     "",        TLONG,
	0x5700000L,     "",          TLONG,
	0x5c00000L,     "",          TLONG,
	0x5f00000L,     "",          TLONG,
	0x5f00000L,     "",         TLONG,
	0x6000000L,     ".",          TLONG,
	0x6000000L,     "",          TLONG,
	0x6000000L,     "atk",          TLONG,
	0x6100000L,     "",          TLONG,
	0x6100000L,     ".",         TLONG,
	0x6100000L,     "stk",          TLONG,
	0x6200000L,     "",          TLONG,
	0x6200000L,     ".",         TLONG,
	0x6200000L,     "ktra",         TLONG,
	0x6300000L,     "",          TLONG,
	0x6300000L,     ".",         TLONG,
	0x6300000L,     "kts",          TLONG,
	0x6400000L,     "",          TLONG,
	0x6400000L,     ".",          TLONG,
	0x6400000L,     "aadk",         TLONG,
	0x6500000L,     "",          TLONG,
	0x6500000L,     ".",          TLONG,
	0x6500000L,     "asuk",         TLONG,
	0x6600000L,     ".",        TLONG,
	0x6600000L,     "",          TLONG,
	0x6600000L,     "ksua",         TLONG,
	0x6700000L,     ".",        TLONG,
	0x6700000L,     "",          TLONG,
	0x6700000L,     "amk",          TLONG,
	0x6800000L,     ".",          TLONG,
	0x6800000L,     "kta",          TLONG,
	0x6900000L,     ".",           TLONG,
	0x6900000L,     "",          TLONG,
	0x6900000L,     "aak",          TLONG,
	0x6a00000L,     ".",         TLONG,
	0x6a00000L,     "",          TLONG,
	0x6a00000L,     "aek",          TLONG,
	0x6b00000L,     ".",         TLONG,
	0x6b00000L,     "",          TLONG,
	0x6b00000L,     "ark",          TLONG,
	0x6c00000L,     "",          TLONG,
	0x6c00000L,     ".",          TLONG,
	0x6c00000L,     "avk",          TLONG,
	0x6d00000L,     ".",         TLONG,
	0x6d00000L,     "",          TLONG,
	0x6d00000L,     "aok",          TLONG,
	0x6e00000L,     "",          TLONG,
	0x6e00000L,     ".",         TLONG,
	0x6e00000L,     "adk",          TLONG,
	0x6f00000L,     "",          TLONG,
	0x6f00000L,     ".",         TLONG,
	0x6f00000L,     "amuk",         TLONG,
	0x7000000L,     "",          TLONG,
	0x7000000L,     ".",         TLONG,
	0x7000000L,     "apk",          TLONG,
	0x7100000L,     ".",         TLONG,
	0x7100000L,     ".",         TLONG,
	0x7100000L,     "auk",          TLONG,
	0x7200000L,     "",          TLONG,
	0x7200000L,     ".",         TLONG,
	0x7200000L,     "ack",          TLONG,
	0x7300000L,     "",          TLONG,
	0x7300000L,     ".",         TLONG,
	0x7300000L,     "ank",          TLONG,
	0x7400000L,     ".",        TLONG,
	0x7400000L,     "",          TLONG,
	0x7400000L,     "eak",          TLONG,
	0x7500000L,     "",          TLONG,
	0x7500000L,     ".",        TLONG,
	0x7500000L,     "esk",          TLONG,
	0x7600000L,     ".",        TLONG,
	0x7600000L,     "",          TLONG,
	0x7600000L,     "ask",          TLONG,
	0x7800000L,     "",          TLONG,
	0x7800000L,     ".",         TLONG,
	0x7800000L,     "ktga",         TLONG,
	0x7900000L,     ".",         TLONG,
	0x7900000L,     "",          TLONG,
	0x7900000L,     "ktsa",         TLONG,
	0x7a00000L,     "",          TLONG,
	0x7a00000L,     ".",         TLONG,
	0x7a00000L,     "ktha",         TLONG,
	0x7b00000L,     ".",         TLONG,
	0x7b00000L,     "",          TLONG,
	0x7b00000L,     "ktta",         TLONG,
	0x7c00000L,     "",          TLONG,
	0x7c00000L,     ".",         TLONG,
	0x7c00000L,     "ztk",          TLONG,
	0x7d00000L,     "",          TLONG,
	0x7d00000L,     ".",         TLONG,
	0x7d00000L,     "atck",         TLONG,
	0x7e00000L,     "",          TLONG,
	0x7e00000L,     ".",        TLONG,
	0x7e00000L,     "alk",          TLONG,
	0x7f00000L,     ".",         TLONG,
	0x7f00000L,     "",          TLONG,
	0x7f00000L,     "atgk",         TLONG,

	0,              0L,             0,
};

/*
 *   
 */

struct table btable [] = {
	0x1200000L,     "",           TLONG|TLIT|TCOMP,
	0x2800000L,     "",           TLONG,
	0x3a00000L,     "",           TLONG,
	0x3f03000L,     "",           TALIGN,
	0x3f18000L,     "",           0,
	0x3f58000L,     "",          0,
	0x6800000L,     "",          TLONG,

	0,              0L,             0,
};

FILE *sfile [SABS], *rfile [SABS];
long count [SABS];
short segm;
char *infile, *outfile = "a.out";
char *tfilename = "/tmp/asXXXXXX";
short line;                             /*    */
short debug;                            /*   */
short xflags, Xflag, uflag;
short stlength;                         /*      */
short stalign;                          /*    */
long cbase, tbase, dbase, adbase, bbase, abase;
struct nlist stab [STSIZE];
short stabfree;
char space [SPACESZ];                   /*     */
short lastfree;                         /*    */
short regleft;                          /*      */
struct { long h, h2, hr2; } constab [CSIZE];
short nconst;
char name [256];
struct word { long left, right; } intval;
short extref;
short blexflag, backlex, blextype;
short hashtab [HASHSZ], hashctab [HCMDSZ];
short hashconst [HCONSZ];
short aflag;                            /*      */

long fgeth (), getexpr (), enterconst (), makehalf (), relhalf ();
char *alloc ();
extern char *mktemp (), *strcpy ();

# define MSG(l,r) (msg ? (r) : (l))

char msg;

initmsg ()
{
	register char *p;
	extern char *getenv ();

	msg = (p = getenv ("MSG")) && *p == 'r';
}

main (argc, argv)
register char *argv[];
{
	register short i;
	register char *cp;
	int ofile = 0;

	initmsg ();

	/*   */

	for (i=1; i<argc; i++) switch (argv[i][0]) {
	case '-':
		for (cp=argv[i]; *cp; cp++) switch (*cp) {
		case 'd':       /*   */
			debug++;
			break;
		case 'b':       /*   */
			setbtable ();
			break;
		case 'X':
			Xflag++;
		case 'x':
			xflags++;
			break;
		case 'a':       /*      */
			aflag++;
			break;
		case 'u':
			uflag++;
			break;
		case 'o':       /*   */
			if (ofile)
				uerror (MSG ("too many -o flags",
					"   -o"));
			ofile = 1;
			if (cp [1]) {
				/* -ofile */
				outfile = cp+1;
				while (*++cp);
				--cp;
			} else if (i+1 < argc)
				/* -o file */
				outfile = argv[++i];
			break;
		}
		break;
	default:
		if (infile)
			uerror (MSG ("too many input files",
				"   "));
		infile = argv[i];
		break;
	}

	/*  - */

	if (infile && ! freopen (infile, "r", stdin))
		uerror (MSG ("cannot open %s", "   %s"), infile);
	if (! freopen (outfile, "w", stdout))
		uerror (MSG ("cannot open %s", "   %s"), outfile);

	i = getchar ();
	ungetc (i=='#' ? ';' : i, stdin);

	startup ();     /*    */
	hashinit ();    /*  - */
	pass1 ();       /*   */
	middle ();      /*   */
	makeheader ();  /*   */
	pass2 ();       /*   */
	makereloc ();   /*    */
	makesymtab ();  /*    */
	exit (0);
}

/* VARARGS1 */

uerror (s, a, b, c)
char *s;
{
	fprintf (stderr, "as: ");
	if (infile) fprintf (stderr, "%s, ", infile);
	fprintf (stderr, "%d: ", line);
	fprintf (stderr, s, a, b, c);
	fprintf (stderr, "\n");
	exit (1);
}

startup ()
{
	register short i;

	mktemp (tfilename);
	for (i=STEXT; i<SBSS; i++) {
		if (! (sfile [i] = fopen (tfilename, "w+")))
			uerror (MSG ("cannot open %s", "   %s"),
				tfilename);
		unlink (tfilename);
		if (! (rfile [i] = fopen (tfilename, "w+")))
			uerror (MSG ("cannot open %s", "   %s"),
				tfilename);
		unlink (tfilename);
	}
	line = 1;
}

middle ()
{
	register short i, snum;

	align (STEXT);
	align (SDATA);
	align (SSTRNG);
	stlength = 0;
	for (snum=0, i=0; i<stabfree; i++) {
		/*     uflag,
		/*     */
		if (stab[i].n_type == N_UNDF)
			if (uflag)
				uerror (MSG ("name undefined",
					" : %s"),
					stab[i].n_name);
			else stab[i].n_type |= N_EXT;
		if (xflags) newindex[i] = snum;
		if (!xflags || (stab[i].n_type & N_EXT) || Xflag &&
			stab[i].n_name[0] != 'L')
		{
			stlength += 2 + W/2 + stab[i].n_len;
			snum++;
		}
	}
	stalign = W - stlength % W;
	stlength += stalign;
}

makeheader ()
{
	struct exec hdr;

	hdr.a_magic = FMAGIC;
	hdr.a_const = nconst * W;
	hdr.a_text = count [STEXT] * (W/2);
	hdr.a_data = (count [SDATA] + count [SSTRNG]) * (W/2);
	hdr.a_bss = count [SBSS] * (W/2);
	hdr.a_abss = count [SABSS] * (W/2);
	hdr.a_syms = stlength;
	hdr.a_entry = HDRSZ/W + count [SCONST] / (W/2);
	hdr.a_flag = 0;
	fputhdr (&hdr, stdout);
}

makereloc ()
{
	register short i;
	register long len;

	for (i=0; i<nconst; i++) {
		fputh (relhalf (constab[i].hr2), stdout);
		fputh (0L, stdout);
	}
	for (segm=STEXT; segm<SBSS; segm++) {
		rewind (rfile [segm]);
		len = count [segm];
		while (len--) fputh (relhalf (fgeth (rfile[segm])), stdout);
	}
}

long relhalf (hr)
register long hr;
{
	register short i;

	switch ((int) hr & REXT) {
	case RSTRNG:
		hr = RDATA | hr & RSHORT;
		break;
	case REXT:
		i = RGETIX (hr);
		if (stab[i].n_type == N_EXT+N_UNDF ||
			stab[i].n_type == N_EXT+N_COMM ||
			stab[i].n_type == N_EXT+N_ACOMM)
		{
			/*  */
			if (xflags)
				hr = hr & (RSHORT|REXT) | RPUTIX (newindex [i]);
		} else
			hr = hr & RSHORT | TYPEREL (stab[i].n_type);
		break;
	}
	return (hr);
}

makesymtab ()
{
	register short i;

	for (i=0; i<stabfree; i++)
		if (!xflags || stab[i].n_type & N_EXT || Xflag &&
			stab[i].n_name[0] != 'L')
			fputsym (&stab[i], stdout);
	while (stalign--) putchar (0);
}

pass1 ()
{
	register short clex;
	int cval, tval, csegm;
	register long addr;

	segm = STEXT;
	while ((clex = getlex (&cval)) != LEOF) {
		switch (clex) {
		case LEOF:
			return;
		case LEOL:
			regleft = 0;
			continue;
		case ':':
			align (segm);
			continue;
		case LNUM:
			ungetlex (clex, cval);
			getexpr (&cval);
			if (cval != SABS)
				uerror (MSG ("bad register number",
					"  "));
			regleft = intval.right & 017;
			continue;
		case LCMD:
			makecmd (table[cval].val, table[cval].type);
			break;
		case LSCMD:
			makecmd ((long) cval<<12 | 0x3f00000L, 0);
			break;
		case LLCMD:
			makecmd ((long) cval<<20, TLONG);
			break;
		case '.':
			if (getlex (&cval) != '=')
				uerror (MSG ("bad command",
					" "));
			align (segm);
			addr = 2 * getexpr (&csegm);
			if (csegm != segm)
				uerror (MSG ("bad count assignment",
					"  "));
			if (addr < count[segm])
				uerror (MSG ("negative count increment",
					"  "));
			if (segm == SBSS)
				count [segm] = addr;
			else while (count[segm] < addr) {
				fputh (segm==STEXT? EMPCOM: 0L, sfile[segm]);
				fputh (0L, rfile[segm]);
				count[segm]++;
			}
			break;
		case LNAME:
			if ((clex = getlex (&tval)) == ':') {
				align (segm);
				stab[cval].n_value = count[segm] / 2;
				stab[cval].n_type &= ~N_TYPE;
				stab[cval].n_type |= SEGMTYPE (segm);
				continue;
			} else if (clex=='=' || clex==LACMD && tval==EQU) {
				stab[cval].n_value = getexpr (&csegm);
				if (csegm == SEXT)
					uerror (MSG ("indirect equivalence",
						" "));
				stab[cval].n_type &= N_EXT;
				stab[cval].n_type |= SEGMTYPE (csegm);
				break;
			} else if (clex==LACMD && (tval==COMM || tval==ACOMM)) {
				/* name .comm len */
				if (stab[cval].n_type != N_UNDF &&
				    stab[cval].n_type != (N_EXT|N_COMM) &&
				    stab[cval].n_type != (N_EXT|N_ACOMM))
					uerror (MSG ("name already defined",
						"  "));
				stab[cval].n_type = N_EXT | (tval==COMM ?
					N_COMM : N_ACOMM);
				getexpr (&tval);
				if (tval != SABS)
					uerror (MSG ("bad length .comm",
						"  .comm"));
				stab[cval].n_value = intval.right;
				break;
			}
			uerror (MSG ("bad command", " "));
		case LACMD:
			switch (cval) {
			case TEXT:
				segm = STEXT;
				break;
			case DATA:
				segm = SDATA;
				break;
			case STRNG:
				segm = SSTRNG;
				break;
			case BSS:
				segm = SBSS;
				break;
			case ABSS:
				segm = SABSS;
				break;
			case HALF:
				for (;;) {
					getexpr (&cval);
					addr = SEGMREL (cval);
					if (cval == SEXT)
						addr |= RPUTIX (extref);
					puthr (intval.right, addr);
					if ((clex = getlex (&cval)) != ',') {
						ungetlex (clex, cval);
						break;
					}
				}
				break;
			case WORD:
				align (segm);
				for (;;) {
					getexpr (&cval);
					addr = SEGMREL (cval);
					if (cval == SEXT)
						addr |= RPUTIX (extref);
					fputh (intval.right, sfile[segm]);
					fputh (addr, rfile[segm]);
					fputh (intval.left, sfile[segm]);
					fputh (0L, rfile[segm]);
					count[segm] += 2;
					if ((clex = getlex (&cval)) != ',') {
						ungetlex (clex, cval);
						break;
					}
				}
				break;
			case ASCII:
				align (segm);
				makeascii ();
				break;
			case GLOBL:
				for (;;) {
					if ((clex = getlex (&cval)) != LNAME)
						uerror (MSG ("bad parameter .globl",
							"  .globl"));
					stab[cval].n_type |= N_EXT;
					if ((clex = getlex (&cval)) != ',') {
						ungetlex (clex, cval);
						break;
					}
				}
				break;
			case COMM:
			case ACOMM:
				/* .comm name,len */
				tval = cval;
				if (getlex (&cval) != LNAME)
					uerror (MSG ("bad parameter .comm",
						"  .comm"));
				if (stab[cval].n_type != N_UNDF &&
				    stab[cval].n_type != (N_EXT|N_COMM) &&
				    stab[cval].n_type != (N_EXT|N_ACOMM))
					uerror (MSG ("name already defined",
						"  "));
				stab[cval].n_type = N_EXT | (tval==COMM ?
					N_COMM : N_ACOMM);
				if ((clex = getlex (&tval)) == ',') {
					getexpr (&tval);
					if (tval != SABS)
						uerror (MSG ("bad length .comm",
							"  .comm"));
				} else {
					ungetlex (clex, cval);
					intval.right = 1;
				}
				stab[cval].n_value = intval.right;
				break;
			}
			break;
		default:
			uerror (MSG ("bad syntax", " "));
		}
		if ((clex = getlex (&cval)) != LEOL)
			if (clex == LEOF) return;
			else uerror (MSG ("bad command end",
				"  "));
		regleft = 0;
	}
}

makecmd (val, type)
long val;
{
	register short clex, index, incr;
	register long addr, reltype;
	int cval, segment;

	index = regleft;
	reltype = RABS;
	for (;;) {
		switch (clex = getlex (&cval)) {
		case LEOF:
		case LEOL:
			ungetlex (clex, cval);
			addr = 0;
			goto putcom;
		case '#':
			getexpr (&segment);
			if (type & TLIT) {
				addr = intval.right >> 19 & 017777;
				if (type & TINT) {
					if (!addr && !intval.left && !(intval.left>>16) ||
						addr==017777 && intval.left==0xfffff)
					{
						addr = intval.right & 0xfffff;
						val |= 0x4000000;
						reltype = SEGMREL (segment);
						if (reltype == REXT)
							reltype |= RPUTIX (extref);
						break;
					}
				} else {
					if (!addr && !intval.left && !(intval.left>>16) ||
						addr==017777 && intval.left==0xffffffff)
					{
						addr = intval.right & 0xfffff;
						val |= 0x4000000;
						reltype = SEGMREL (segment);
						if (reltype == REXT)
							reltype |= RPUTIX (extref);
						break;
					}
				}
			}
			addr = enterconst (segment);
			reltype = RCONST;
			break;
		case '[':
			makecmd (WTCCOM, TLONG);
			if (getlex (&cval) != ']')
				uerror (MSG ("bad [] syntax", "  []"));
			continue;
		case '<':
			makecmd (UTCCOM, TLONG);
			if (getlex (&cval) != '>')
				uerror (MSG ("bad <> syntax", "  <>"));
			continue;
		default:
			ungetlex (clex, cval);
			addr = getexpr (&segment);
			reltype = SEGMREL (segment);
			if (reltype == REXT)
				reltype |= RPUTIX (extref);
			break;
		}
		break;
	}
	if ((clex = getlex (&cval)) == ',') {
		index = getexpr (&segment);
		if (segment != SABS)
			uerror (MSG ("bad register number",
				"  "));
		if ((type & TCOMP) && addr==0 && reltype==RABS) {
			if ((clex = getlex (&cval)) == LINCR || clex==LDECR) {
				incr = getexpr (&segment);
				if (segment != SABS)
					uerror (MSG ("bad register increment",
						"  "));
				if (incr == 0)
					incr = 1;
				/*    */
				addr = clex==LINCR ? incr : -incr;
				val = MAKECOMP (val);
			} else
				ungetlex (clex, cval);
		}
	} else
		ungetlex (clex, cval);
putcom:
	if (type & TLONG) {
		if (reltype & REXT == REXT &&
			stab[RGETIX(reltype)].n_type == N_EXT+N_ACOMM)
		{
			/*     ACOMM,
			/*    utc */
			puthr ((long) index<<28 | UTCCOM | addr>>12 & 0xfffff,
				reltype | RSHIFT);
			puthr (val | addr&07777, (long) RABS | RTRUNC);
		} else {
			addr &= 0xfffff;
			puthr ((long) index<<28 | val | addr & 0xfffff,
				reltype | RLONG);
		}
	} else {
		puthr ((long) index<<28 | val | addr & 07777,
			reltype | RSHORT);
	}
	if (! aflag && (type & TALIGN))
		align (segm);
}

puthr (h, r)
register long h, r;
{
	static long sh, sr;

	if (count[segm] & 01) {
		fputh (h, sfile[segm]);
		fputh (r, rfile[segm]);
		fputh (sh, sfile[segm]);
		fputh (sr, rfile[segm]);
	} else {
		sh = h;
		sr = r;
	}
	count[segm]++;
}

makeascii ()
{
	register short c, n;
	int cval;

	c = getlex (&cval);
	if (c != '"')
		uerror (MSG ("no .ascii parameter", "  .ascii"));
	n = 0;
	for (;;) {
		switch (c = getchar ()) {
		case EOF:
			uerror (MSG ("EOF in text string",
				"  "));
		case '"':
			break;
		case '\\':
			switch (c = getchar ()) {
			case EOF:
				uerror (MSG ("EOF in text string",
					"  "));
			case '\n':
				continue;
			case '0': case '1': case '2': case '3':
			case '4': case '5': case '6': case '7':
				cval = c & 07;
				c = getchar ();
				if (c>='0' && c<='7') {
					cval = cval<<3 | c&7;
					c = getchar ();
					if (c>='0' && c<='7') {
						cval = cval<<3 | c&7;
					} else ungetc (c, stdin);
				} else ungetc (c, stdin);
				c = cval;
				break;
			case 't':
				c = '\t';
				break;
			case 'b':
				c = '\b';
				break;
			case 'r':
				c = '\r';
				break;
			case 'n':
				c = '\n';
				break;
			case 'f':
				c = '\f';
				break;
			}
		default:
			fputc (c, sfile[segm]);
			n++;
			continue;
		}
		break;
	}
	c = W - n % W;
	n = (n + c) / (W/2);
	count[segm] += n;
	while (c--) fputc (0, sfile[segm]);
	while (n--) fputh (0L, rfile[segm]);
}

align (s)
register s;
{
	register short save;

	if (s != segm) {
		save = segm;
		segm = s;
	} else save = -1;
	if (count[s] & 01)
		puthr (s==STEXT ? EMPCOM : 0L, (long) RABS);
	if (save >= 0) segm = save;
}

long adjust (h, a, hr)
register long h, a;
register hr;
{
	switch (hr & RSHORT) {
	case 0:
		a += h & 0777777777;
		h &= ~0777777777;
		h |= a & 0777777777;
		break;
	case RSHORT:
		a += h & 07777;
		h &= ~07777;
		h |= a & 07777;
		break;
	case RSHIFT:
		a >>= 12;
		goto rlong;
	case RTRUNC:
		a &= 07777;
	case RLONG:
rlong:          a += h & 0xfffff;
		h &= ~0xfffff;
		h |= a & 0xfffff;
		break;
	}
	return (h);
}

pass2 ()
{
	register short i;
	register long h;

	cbase = HDRSZ/W;
	tbase = cbase + nconst;
	dbase = tbase + count[STEXT]/2;
	adbase = dbase + count[SDATA]/2;
	bbase = adbase + count[SSTRNG]/2;
	abase = bbase + count[SBSS]/2;

	/*    */
	for (i=0; i<stabfree; i++) {
		h = stab[i].n_value;
		switch (stab[i].n_type & N_TYPE) {
		case N_UNDF:
		case N_ABS:
			break;
		case N_CONST:
			h = adjust (h, cbase, 0);
			break;
		case N_TEXT:
			h = adjust (h, tbase, 0);
			break;
		case N_DATA:
			h = adjust (h, dbase, 0);
			break;
		case N_STRNG:
			h = adjust (h, adbase, 0);
			stab[i].n_type += N_DATA - N_STRNG;
			break;
		case N_BSS:
			h = adjust (h, bbase, 0);
			break;
		case N_ABSS:
			h = adjust (h, abase, 0);
			break;
		}
		stab[i].n_value = h;
	}
	/*    */
	for (i=0; i<nconst; i++) {
		fputh (makehalf (constab[i].h2, constab[i].hr2), stdout);
		fputh (constab[i].h, stdout);
	}
	for (segm=STEXT; segm<SBSS; segm++) {
		rewind (sfile [segm]);
		rewind (rfile [segm]);
		h = count [segm];
		while (h--) fputh (makehalf (fgeth (sfile[segm]),
			fgeth (rfile[segm])), stdout);
	}
}

long makehalf (h, hr)
register long h, hr;
{
	register short i;

	switch ((int) hr & REXT) {
	case RABS:
		break;
	case RCONST:
		h = adjust (h, cbase, (int) hr);
		break;
	case RTEXT:
		h = adjust (h, tbase, (int) hr);
		break;
	case RDATA:
		h = adjust (h, dbase, (int) hr);
		break;
	case RSTRNG:
		h = adjust (h, adbase, (int) hr);
		break;
	case RBSS:
		h = adjust (h, bbase, (int) hr);
		break;
	case RABSS:
		h = adjust (h, abase, (int) hr);
		break;
	case REXT:
		i = RGETIX (hr);
		if (stab[i].n_type != N_EXT+N_UNDF &&
			stab[i].n_type != N_EXT+N_COMM &&
			stab[i].n_type != N_EXT+N_ACOMM)
			h = adjust (h, stab[i].n_value, (int) hr);
		break;
	}
	return (h);
}

/*
 * int getlex (int *val) -  ,   ,
 *   *val  .
 *   :
 *      LEOL    -  .  -   .
 *      LEOF    -  .
 *      LNUM    -  .  -  intval, *val  .
 *      LCMD    -  .  -    table.
 *      LNAME   - .  -   stab.
 *      LACMD   -  .  - .
 *      LLCMD   -  .  - .
 *      LSCMD   -  .  - .
 */

getlex (pval)
register *pval;
{
	register short c;

	if (blexflag) {
		blexflag = 0;
		*pval = blextype;
		return (backlex);
	}
	for (;;) switch (c = getchar()) {
	case ';':
skiptoeol:      while ((c = getchar()) != '\n')
			if (c == EOF) return (LEOF);
	case '\n':
		c = getchar ();
		if (c == '#')
			goto skiptoeol;
		ungetc (c, stdin);
		*pval = ++line;
		return (LEOL);
	case ' ':
	case '\t':
		continue;
	case EOF:
		return (LEOF);
	case '\\':
		c = getchar ();
		if (c=='<')
			return (LLSHIFT);
		if (c=='>')
			return (LRSHIFT);
		ungetc (c, stdin);
		return ('\\');
	case '+':
		if ((c = getchar ()) == '+')
			return (LINCR);
		ungetc (c, stdin);
		return ('+');
	case '-':
		if ((c = getchar ()) == '-')
			return (LINCR);
		ungetc (c, stdin);
		return ('-');
	case '^':       case '&':       case '|':       case '~':
	case '#':       case '*':       case '/':       case '%':
	case '"':       case ',':       case '[':       case ']':
	case '(':       case ')':       case '{':       case '}':
	case '<':       case '>':       case '=':       case ':':
		return (c);
	case '\'':
		getlhex (c);
		return (LNUM);
	case '0':
		if ((c = getchar ()) == 'x' || c=='X') {
			gethnum ();
			return (LNUM);
		}
		ungetc (c, stdin);
		c = '0';
	case '1':       case '2':       case '3':
	case '4':       case '5':       case '6':       case '7':
	case '8':       case '9':
		getnum (c);
		return (LNUM);
	case '@':
	case '$':
		*pval = hexdig (getchar ());
		*pval = *pval<<4 | hexdig (getchar ());
		return (c=='$' ? LSCMD : LLCMD);
	default:
		if (!ISLETTER (c))
			uerror (MSG ("bad character: \\%o",
				" : \\%o"), c & 0377);
		if (c=='.') {
			c = getchar();
			if (c == '[') {
				getbitmask ();
				return (LNUM);
			} else if (ISOCTAL (c)) {
				getbitnum (c);
				return (LNUM);
			}
			ungetc (c, stdin);
			c = '.';
		}
		getname (c);
		if (name[0]=='.') {
			if (name[1]==0) return ('.');
			if ((*pval = lookacmd()) != -1) return (LACMD);
		}
		if ((*pval = lookcmd()) != -1) return (LCMD);
		*pval = lookname ();
		return (LNAME);
	}
}

ungetlex (val, type)
{
	blexflag = 1;
	backlex = val;
	blextype = type;
}

hexdig (c)
register c;
{
	if (c <= '9')
		return (c - '0');
	else if (c <= 'F')
		return (c - 'A' + 10);
	else
		return (c - 'a' + 10);
}

getbitnum (c)
register c;
{
	/*   .N,  N -   */

	getnum (c);
	c = intval.right - 1;
	if (c < 0 || c >= 64)
		uerror (MSG ("bit number out of range 1..64",
			"    1..64"));
	if (c >= 32) {
		intval.left = 1 << (c-32);
		intval.right = 0;
	} else {
		intval.right = 1 << c;
		intval.left = 0;
	}
}

getbitmask ()
{
	/*   .[a:b],  a, b -   */
	/*  .[a=b] */
	register c, a, b;
	int v, compl;

	a = getexpr (&v) - 1;
	if (v != SABS)
		uerror (MSG ("illegal expression in bit mask",
			"    "));
	c = getlex (&v);
	if (c != ':' && c != '=')
		uerror (MSG ("illegal bit mask delimiter",
			"    "));
	compl = c == '=';
	b = getexpr (&v) - 1;
	if (v != SABS)
		uerror (MSG ("illegal expression in bit mask",
			"    "));
	c = getlex (&v);
	if (c != ']')
		uerror (MSG ("illegal bit mask delimiter",
			"    "));
	if (a<0 || a>=64 || b<0 || b>=64)
		uerror (MSG ("bit number out of range 1..64",
			"    1..64"));
	if (a < b)
		c = a, a = b, b = c;
	if (compl && --a < ++b) {
		intval.left = 0xffffffff;
		intval.right = 0xffffffff;
		return;
	}
	/* a greater than or equal to b */
	if (a >= 32) {
		if (b >= 32) {
			intval.left = (unsigned long) ~0L >> (63-a+b-32) << (b-32);
			intval.right = 0;
		} else {
			intval.left = (unsigned long) ~0L >> (63-a);
			intval.right = (unsigned long) ~0L << b;
		}
	} else {
		intval.left = 0;
		intval.right = (unsigned long) ~0L >> (31-a+b) << b;
	}
	intval.left &= 0xffffffff;
	intval.right &= 0xffffffff;
	if (compl) {
		intval.left ^= 0xffffffff;
		intval.right ^= 0xffffffff;
	}
}

getlhex ()
{
	register c;
	register char *cp, *p;

	/*    'ZZZ */

	c = getchar ();
	for (cp=name; ISHEX(c); c=getchar()) *cp++ = hexdig (c);
	ungetc (c, stdin);
	intval.left = 0;
	intval.right = 0;
	p = name;
	for (c=28; c>=0; c-=4, ++p) {
		if (p >= cp) return;
		intval.left |= (long) *p << c;
	}
	for (c=28; c>=0; c-=4, ++p) {
		if (p >= cp) return;
		intval.right |= (long) *p << c;
	}
}

gethnum ()
{
	register c;
	register char *cp;

	/*    0xZZZ */

	c = getchar ();
	for (cp=name; ISHEX(c); c=getchar()) *cp++ = hexdig (c);
	ungetc (c, stdin);
	intval.left = 0;
	intval.right = 0;
	for (c=0; c<32; c+=4) {
		if (--cp < name) return;
		intval.right |= (long) *cp << c;
	}
	for (c=0; c<32; c+=4) {
		if (--cp < name) return;
		intval.left |= (long) *cp << c;
	}
}

getnum (c)
register c;
{
	register char *cp;
	int leadingzero;
	/*   */
	/* 1234 1234d 1234D -  */
	/* 01234 1234. 1234o 1234O -  */
	/* 1234' 1234h 1234H -  */

	leadingzero = (c=='0');
	for (cp=name; ISHEX(c); c=getchar()) *cp++ = hexdig (c);
	intval.left = 0;
	intval.right = 0;
	if (c=='.' || c=='o' || c=='O') {
octal:
		for (c=0; c<=27; c+=3) {
			if (--cp < name) return;
			intval.right |= (long) *cp << c;
		}
		if (--cp < name) return;
		intval.right |= (long) *cp << 30;
		intval.left = (long) *cp >> 2;
		for (c=1; c<=31; c+=3) {
			if (--cp < name) return;
			intval.left |= (long) *cp << c;
		}
		return;
	} else if (c=='h' || c=='H' || c=='\'') {
		for (c=0; c<32; c+=4) {
			if (--cp < name) return;
			intval.right |= (long) *cp << c;
		}
		for (c=0; c<32; c+=4) {
			if (--cp < name) return;
			intval.left |= (long) *cp << c;
		}
		return;
	} else if (c!='d' && c!='D') {
		ungetc (c, stdin);
		if (leadingzero)
			goto octal;
	}
	for (c=1; ; c*=10) {
		if (--cp < name) return;
		intval.right += (long) *cp * c;
	}
}

getname (c)
register c;
{
	register char *cp;

	for (cp=name; ISLETTER (c) || ISDIGIT (c); c=getchar())
		*cp++ = c;
	*cp = 0;
	ungetc (c, stdin);
}

lookacmd ()
{
	switch (name [1]) {
	case 'a':
		if (! strcmp (".ascii", name)) return (ASCII);
		if (! strcmp (".acomm", name)) return (ACOMM);
		if (! strcmp (".abss", name)) return (ABSS);
		break;
	case 'b':
		if (! strcmp (".bss", name)) return (BSS);
		break;
	case 'c':
		if (! strcmp (".comm", name)) return (COMM);
		break;
	case 'd':
		if (! strcmp (".data", name)) return (DATA);
		break;
	case 'e':
		if (! strcmp (".equ", name)) return (EQU);
		break;
	case 'g':
		if (! strcmp (".globl", name)) return (GLOBL);
		break;
	case 'h':
		if (! strcmp (".half", name)) return (HALF);
		break;
	case 's':
		if (! strcmp (".strng", name)) return (STRNG);
		break;
	case 't':
		if (! strcmp (".text", name)) return (TEXT);
		break;
	case 'w':
		if (! strcmp (".word", name)) return (WORD);
		break;
	case (char) '':
		if (! strcmp (".", name)) return (COMM);
		break;
	case (char) '':
		if (! strcmp (".", name)) return (GLOBL);
		break;
	case (char) '':
		if (! strcmp (".", name)) return (DATA);
		break;
	case (char) '':
		if (! strcmp (".", name)) return (WORD);
		if (! strcmp (".8", name)) return (ASCII);
		break;
	case (char) '':
		if (! strcmp (".", name)) return (ACOMM);
		if (! strcmp (".", name)) return (ABSS);
		break;
	case (char) '':
		if (! strcmp (".", name)) return (BSS);
		if (! strcmp (".", name)) return (HALF);
		if (! strcmp (".", name)) return (COMM);
		break;
	case (char) '':
		if (! strcmp (".", name)) return (WORD);
		if (! strcmp (".", name)) return (STRNG);
		break;
	case (char) '':
		if (! strcmp (".", name)) return (TEXT);
		break;
	case (char) '':
		if (! strcmp (".", name)) return (EQU);
		break;
	}
	return (-1);
}

hashinit ()
{
	register short i, h;
	register struct table *p;

	for (i=0; i<HCONSZ; i++)
		hashconst[i] = -1;
	for (i=0; i<HCMDSZ; i++)
		hashctab[i] = -1;
	for (p=table; p->name; p++) {
		h = chash (p->name);
		while (hashctab[h] != -1)
			if (--h < 0)
				h += HCMDSZ;
		hashctab[h] = p - table;
	}
	for (i=0; i<HASHSZ; i++)
		hashtab[i] = -1;
}

lookcmd ()
{
	register short i, h;

	h = chash (name);
	while ((i = hashctab[h]) != -1) {
		if (!strcmp (table[i].name, name)) return (i);
		if (--h < 0) h += HCMDSZ;
	}
	return (-1);
}

hash (s)
register char *s;
{
	register short h, c;

	h = 12345;
	while (c = *s++) h += h + c;
	return (SUPERHASH (h, HASHSZ-1));
}

chash (s)
register char *s;
{
	register short h, c;

	h = 12345;
	while (c = *s++) h += h + c;
	return (SUPERHASH (h, HCMDSZ-1));
}

lookname ()
{
	register short i, h;

	h = hash (name);
	while ((i = hashtab[h]) != -1) {
		if (!strcmp (stab[i].n_name, name)) return (i);
		if (--h < 0) h += HASHSZ;
	}

	/*      */

	if ((i = stabfree++) >= STSIZE)
		uerror (MSG ("symbol table overflow",
			"  "));
	stab[i].n_len = strlen (name);
	stab[i].n_name = alloc (1 + stab[i].n_len);
	strcpy (stab[i].n_name, name);
	stab[i].n_value = 0;
	stab[i].n_type = 0;
	hashtab[h] = i;
	return (i);
}

char *alloc (len)
{
	register short r;

	r = lastfree;
	if ((lastfree += len) > SPACESZ)
		uerror (MSG ("out of memory", " "));
	return (space + r);
}

long enterconst (bs)
{
	register short hash, i;
	register long h, h2, hr2;

	h = intval.left;
	h2 = intval.right;
	hr2 = SEGMREL (bs);
	if (bs == SEXT) hr2 |= RPUTIX (extref);
	hash = SUPERHASH (h+h2+hr2, HCONSZ-1);
	while ((i = hashconst[hash]) != -1) {
		if (h==constab[i].h && h2==constab[i].h2 && hr2==constab[i].hr2)
			return (i);
		if (--hash < 0) hash += HCONSZ;
	}
	hashconst[hash] = nconst;
	constab[nconst].h = h;
	constab[nconst].h2 = h2;
	constab[nconst].hr2 = hr2;
	return (nconst++);
}

/*
 * long getexpr (int *s) -  .
 *  ,      *s.
 *  4   ,
 *     intval.
 *
 *     = [] { }...
 *       = LNAME | LNUM | "." | "("  ")" | "{"  "}"
 *      = "+" | "-" | "&" | "|" | "^" | "~" | "\" | "/" | "*" | "%"
 */

long getexpr (s)
register *s;
{
	register short clex;
	int cval, s2;
	struct word rez;

	/*    */
	switch (clex = getlex (&cval)) {
	default:
		ungetlex (clex, cval);
		rez.left = rez.right = 0;
		*s = SABS;
		break;
	case LNUM:
	case LNAME:
	case '.':
	case '(':
	case '{':
		ungetlex (clex, cval);
		*s = getterm ();
		rez = intval;
		break;
	}
	for (;;) {
		switch (clex = getlex (&cval)) {
			register long t;
		case '+':
			s2 = getterm ();
			if (*s == SABS) *s = s2;
			else if (s2 != SABS)
				uerror (MSG ("too complex expression",
					"  "));
			t = rez.right>>16 & 0xffff;
			rez.right &= 0xffff;
			rez.right += intval.right & 0xffff;
			if (rez.right & ~0xffff) t++;
			rez.right &= 0xffff;
			t += intval.right>>16 & 0xffff;
			rez.right |= t << 16;
			rez.left += intval.left;
			if (t & ~0xffff) rez.left++;
			break;
		case '-':
			s2 = getterm ();
			if (s2 != SABS)
				uerror (MSG ("too complex expression",
					"  "));
			t = rez.right>>16 & 0xffff;
			rez.right &= 0xffff;
			rez.right -= intval.right & 0xffff;
			if (rez.right & ~0xffff) t--;
			rez.right &= 0xffff;
			t -= intval.right>>16 & 0xffff;
			rez.right |= t << 16;
			rez.left -= intval.left;
			if (t & ~0xffff) rez.left--;
			break;
		case '&':
			s2 = getterm ();
			if (*s != SABS || s2 != SABS)
				uerror (MSG ("too complex expression",
					"  "));
			rez.left &= intval.left;
			rez.right &= intval.right;
			break;
		case '|':
			s2 = getterm ();
			if (*s != SABS || s2 != SABS)
				uerror (MSG ("too complex expression",
					"  "));
			rez.left |= intval.left;
			rez.right |= intval.right;
			break;
		case '^':
			s2 = getterm ();
			if (*s != SABS || s2 != SABS)
				uerror (MSG ("too complex expression",
					"  "));
			rez.left ^= intval.left;
			rez.right ^= intval.right;
			break;
		case '~':
			s2 = getterm ();
			if (*s != SABS || s2 != SABS)
				uerror (MSG ("too complex expression",
					"  "));
			rez.left ^= ~intval.left;
			rez.right ^= ~intval.right;
			break;
		case LLSHIFT:           /*   */
			s2 = getterm ();
			if (*s != SABS || s2 != SABS)
				uerror (MSG ("too complex expression",
					"  "));
			clex = intval.right & 077;
			if (clex<32) {
				rez.left <<= clex;
				rez.left |= rez.right >> (32-clex);
				rez.right <<= clex;
			} else {
				rez.left = rez.right << (clex-32);
				rez.right = 0;
			}
			break;
		case LRSHIFT:           /*   */
			s2 = getterm ();
			if (*s != SABS || s2 != SABS)
				uerror (MSG ("too complex expression",
					"  "));
			clex = intval.right & 077;
			if (clex<32) {
				rez.right >>= clex;
				rez.right |= rez.left << (32-clex);
				rez.left >>= clex;
			} else {
				rez.right = rez.left >> (clex-32);
				rez.left = 0;
			}
			break;
		case '*':       /* 31-  */
			s2 = getterm ();
			if (*s != SABS || s2 != SABS)
				uerror (MSG ("too complex expression",
					"  "));
			rez.left = 0;
			rez.right *= intval.right;
			break;
		case '/':       /* 31-  */
			s2 = getterm ();
			if (*s != SABS || s2 != SABS)
				uerror (MSG ("too complex expression",
					"  "));
			rez.left = 0;
			if (intval.right)
				rez.right /= intval.right;
			else
				uerror (MSG ("division by zero",
					"  0"));
			break;
		case '%':       /* 31-  */
			s2 = getterm ();
			if (*s != SABS || s2 != SABS)
				uerror (MSG ("too complex expression",
					"  "));
			rez.left = 0;
			if (intval.right)
				rez.right %= intval.right;
			else
				uerror (MSG ("division (%%) by zero",
					" (%%)  0"));
			break;
		default:
			ungetlex (clex, cval);
			intval = rez;
			return (rez.right);
		}
	}
	/* NOTREACHED */
}

getterm ()
{
	register ty;
	int cval, s;

	switch (getlex (&cval)) {
	default:
		uerror (MSG ("operand missed", " "));
	case LNUM:
		return (SABS);
	case LNAME:
		intval.left = intval.right = 0;
		ty = stab[cval].n_type & N_TYPE;
		if (ty==N_UNDF || ty==N_COMM || ty==N_ACOMM) {
			extref = cval;
			return (SEXT);
		}
		intval.right = stab[cval].n_value;
		return (TYPESEGM (ty));
	case '.':
		intval.left = 0;
		intval.right = count[segm] / 2;
		return (segm);
	case '(':
		getexpr (&s);
		if (getlex (&cval) != ')')
			uerror (MSG ("bad () syntax", "  ()"));
		return (s);
	case '{':
		/*   */
		getexpr (&s);
		if (getlex (&cval) != '}')
			uerror (MSG ("bad () syntax", "  ()"));
		intval.left &= 07777777L;
		return (s);
	}
}

typerel (t)     /*       */
{
	switch (t & N_TYPE) {
	case N_ABS:     return (RABS);
	case N_CONST:   return (RCONST);
	case N_TEXT:    return (RTEXT);
	case N_DATA:    return (RDATA);
	case N_BSS:     return (RBSS);
	case N_ABSS:    return (RABSS);
	case N_STRNG:   return (RDATA);
	case N_UNDF:
	case N_COMM:
	case N_ACOMM:
	case N_FN:
	default:        return (0);
	}
}

setbtable ()
{
	/*    */
	register struct table *p, *b;

	for (b=btable; b->name; ++b)
		for (p=table; p->name; ++p)
			if (! strcmp (b->name, p->name))
				*p = *b;
}
