//
// Пример для PIC32 на языке ассемблера.
// Файл имеет расширение .S - ассебмлер с препроцессором Си.
// Copyright (C) 2012 Сергей Вакуленко
//
#include <p32xxxx.h>

        .text                       // Начинаем секцию выполняемого кода.
        .set noreorder              // Отключаем переупорядочивание инструкций

//
// Обработчик прерывания от таймера.
//
timer_handler:
	addiu	sp, sp, -136        // Выделяем в стеке 34 слова

	mfc0	k0, _CP0_EPC        // Сохраняем адрес возврата EPC
	sw	k0, 132(sp)

	mfc0	k1, _CP0_STATUS     // Сохраняем режим процессора Status
	sw	k1, 128(sp)

	mflo	k0
	sw	k0, 124(sp)         // Регистр LO

	mfhi	k1
	sw	k1, 120(sp)         // Регистр HI

	sw	ra, 116(sp)         // Регистр 31
	sw	s8, 112(sp)         // Регистр 30
	sw	t9, 108(sp)         // Регистр 25
	sw	t8, 104(sp)         // Регистр 24
	sw	s7, 100(sp)         // Регистр 23
	sw	s6, 96(sp)          // Регистр 22
	sw	s5, 92(sp)          // Регистр 21
	sw	s4, 88(sp)          // Регистр 20
	sw	s3, 84(sp)          // Регистр 19
	sw	s2, 80(sp)          // Регистр 18
	sw	s1, 76(sp)          // Регистр 17
	sw	s0, 72(sp)          // Регистр 16
	sw	t7, 68(sp)          // Регистр 15
	sw	t6, 64(sp)          // Регистр 14
	sw	t5, 60(sp)          // Регистр 13
	sw	t4, 56(sp)          // Регистр 12
	sw	t3, 52(sp)          // Регистр 11
	sw	t2, 48(sp)          // Регистр 10
	sw	t1, 44(sp)          // Регистр 9
	sw	t0, 40(sp)          // Регистр 8
	sw	a3, 36(sp)          // Регистр 7
	sw	a2, 32(sp)          // Регистр 6
	sw	a1, 28(sp)          // Регистр 5
	sw	a0, 24(sp)          // Регистр 4
	sw	v1, 20(sp)          // Регистр 3
	sw	v0, 16(sp)          // Регистр 2
	sw	$1, 12(sp)          // Регистр 1

        // Меняем значение указателя стека: переключение на другую задачу.
        jal     task_switch
	move	a0, sp
	move	sp, v0              // sp = task_switch (sp)

        // Восстанавливаем все регистры из стека.
	lw	a1, 132(sp)
	mtc0	a1, _CP0_EPC        // Адрес возврата EPC

	lw	a1, 128(sp)
	mtc0	a1, _CP0_STATUS     // Режим процессора Status

	lw	a1, 124(sp)
	mtlo	a1                  // Регистр LO

	lw	a1, 120(sp)
	mthi	a1                  // Регистр HI

	lw	ra, 116(sp)         // Регистр 31
	lw	s8, 112(sp)         // Регистр 30
	lw	t9, 108(sp)         // Регистр 25
	lw	t8, 104(sp)         // Регистр 24
	lw	s7, 100(sp)         // Регистр 23
	lw	s6, 96(sp)          // Регистр 22
	lw	s5, 92(sp)          // Регистр 21
	lw	s4, 88(sp)          // Регистр 20
	lw	s3, 84(sp)          // Регистр 19
	lw	s2, 80(sp)          // Регистр 18
	lw	s1, 76(sp)          // Регистр 17
	lw	s0, 72(sp)          // Регистр 16
	lw	t7, 68(sp)          // Регистр 15
	lw	t6, 64(sp)          // Регистр 14
	lw	t5, 60(sp)          // Регистр 13
	lw	t4, 56(sp)          // Регистр 12
	lw	t3, 52(sp)          // Регистр 11
	lw	t2, 48(sp)          // Регистр 10
	lw	t1, 44(sp)          // Регистр 9
	lw	t0, 40(sp)          // Регистр 8
	lw	a3, 36(sp)          // Регистр 7
	lw	a2, 32(sp)          // Регистр 6
	lw	a1, 28(sp)          // Регистр 5
	lw	a0, 24(sp)          // Регистр 4
	lw	v1, 20(sp)          // Регистр 3
	lw	v0, 16(sp)          // Регистр 2
	lw	$1, 12(sp)          // Регистр 1

	addiu	sp, sp, 136         // Освобождаем место в стеке
	eret                        // Выходим из прерывания

        //
        // Специальная секция кода, которую загрузчик
        // разместит по адресу входа в прерывание 0.
        //
        .section .vector_0, "ax", @progbits
timer_vector:
        j       timer_handler
        nop
